/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman.stealthblack;

import java.util.ArrayList;
import java.util.Arrays;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class StealthReflexAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"stealth_reflex", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user dashes forward and vanishes, being immune to most damage sources while active.", null)});
    private static final float HOLD_TIME = 20.0f;
    private static final float MIN_COOLDOWN = 80.0f;
    private static final float MAX_COOLDOWN = 300.0f;
    private static final float PROTECTION_TIME = 10.0f;
    public static final AbilityCore<StealthReflexAbility> INSTANCE = new AbilityCore.Builder("Stealth Reflex", AbilityCategory.RACIAL, StealthReflexAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)80.0f, (float)300.0f), ContinuousComponent.getTooltip((float)20.0f)}).setUnlockCheck(StealthReflexAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(100, this::onStartContinuityEvent).addTickEvent(100, this::duringContinuityEvent).addEndEvent(100, this::onEndContinuityEvent);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.DODGE_ABILITY, new AbilityPool2[0]);
    private final DamageTakenComponent damageTakenComponent;
    private int hitsTaken = 0;
    private float protTimer = 10.0f;
    private boolean hasFallDamage;
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.STEALTH_BLACK.get(), new MorphInfo[0]);

    public StealthReflexAbility(AbilityCore<StealthReflexAbility> core) {
        super(core);
        this.damageTakenComponent = new DamageTakenComponent((IAbility)this).addOnAttackEvent(this::onDamageTakenEvent);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.poolComponent, this.damageTakenComponent, this.requireMorphComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addCanUseCheck(AbilityHelper::requiresFocus);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 20.0f);
    }

    private void onStartContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitsTaken = 0;
        this.protTimer = 0.0f;
        Vector3d look = entity.func_70040_Z().func_216372_d(4.0, entity.func_70040_Z().field_72448_b >= 0.0 ? 0.0 : 0.6, 4.0);
        if (entity.field_191988_bg < 0.0f) {
            look = look.func_216372_d(-1.0, 1.0, -1.0);
        }
        if (entity.func_70090_H()) {
            look = look.func_216372_d(0.5, 0.5, 0.5);
        }
        AbilityHelper.setDeltaMovement((Entity)entity, (Vector3d)look);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.hasFallDamage = false;
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.VANISH.get(), 5, 0, false, false));
        if (this.protTimer > 0.0f) {
            this.protTimer -= 1.0f;
        }
    }

    private void onEndContinuityEvent(LivingEntity entity, IAbility ability) {
        float cooldown = 80.0f + this.continuousComponent.getContinueTime() * 5.0f + 5.0f * (float)Math.pow(this.hitsTaken, this.hitsTaken);
        cooldown = Math.min(300.0f, cooldown);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    public float onDamageTakenEvent(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        if (super.isContinuous() && AbilityHelper.canUseMomentumAbilities((LivingEntity)entity) && !AbilityHelper.isGrabbing((LivingEntity)entity)) {
            boolean isDamageTaken = true;
            boolean isUnavoidable = damageSource instanceof ModDamageSource && ((ModDamageSource)damageSource).isUnavoidable();
            ArrayList<String> acceptableInstantSources = new ArrayList<String>(Arrays.asList("mob", "player", "ability_projectile", "ability"));
            if ((damageSource.func_76364_f() instanceof LivingEntity || damageSource.func_76364_f() instanceof ProjectileEntity) && acceptableInstantSources.contains(damageSource.func_76355_l()) && !isUnavoidable) {
                isDamageTaken = false;
            }
            if (this.protTimer <= 0.0f) {
                if (!isDamageTaken) {
                    SoundEvent sfx = (SoundEvent)ModSounds.DODGE_1.get();
                    if (entity.func_70681_au().nextBoolean()) {
                        sfx = (SoundEvent)ModSounds.DODGE_2.get();
                    }
                    entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), sfx, SoundCategory.PLAYERS, 1.0f, 0.75f + entity.func_70681_au().nextFloat() / 3.0f);
                    ++this.hitsTaken;
                    this.protTimer = 10.0f;
                }
                return isDamageTaken ? damage : 0.0f;
            }
            return 0.0f;
        }
        return damage;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getSubRace().equals("stealth_black");
    }
}

