/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman.stealthblack;

import java.util.List;
import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.HoverBootsAbility;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.DropHitAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SobaKickAbility
extends DropHitAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"soba_kick", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user gains height and rapidly accelerates down at their enemy, stunning them.", null)});
    public static final AbilityCore<SobaKickAbility> INSTANCE = new AbilityCore.Builder("Soba Kick", AbilityCategory.RACIAL, SobaKickAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)15.0f, (float)85.0f), CooldownComponent.getTooltip((float)600.0f, (float)800.0f), RangeComponent.getTooltip((float)5.0f, (float)12.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceType(new SourceType[]{SourceType.FIST}).setSourceHakiNature(SourceHakiNature.HARDENING).setUnlockCheck(SobaKickAbility::canUnlock).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.INIT_JUMP, new AbilityPool2[]{ModAbilityPools.GRAB_ABILITY});
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.STEALTH_BLACK.get(), new MorphInfo[0]);
    private static final int COOLDOWN = 800;
    private static final float RANGE = 5.0f;
    private static final float DMG = 85.0f;

    public SobaKickAbility(AbilityCore<SobaKickAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.requireMorphComponent, this.poolComponent, this.poolComponent, this.animationComponent, this.dealDamageComponent, this.rangeComponent});
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(100, this::endContinuityEvent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
    }

    public void onLanding(LivingEntity entity) {
        this.animationComponent.stop(entity);
        List targets = this.rangeComponent.getTargetsInArea(entity, 5.0f);
        targets.remove(entity);
        AbilityDamageSource source = (AbilityDamageSource)ModDamageSource.causeAbilityDamage((LivingEntity)entity, (AbilityCore)this.getCore()).setFistDamage();
        for (LivingEntity target : targets) {
            float damage = 85.0f;
            if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, damage, (DamageSource)source)) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 20));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 20));
            AbilityHelper.disableAbilities((LivingEntity)target, (int)100, abl -> abl.hasComponent(ModAbilityKeys.POOL) && ((PoolComponent)abl.getComponent(ModAbilityKeys.POOL).get()).containsPool(ModAbilityPools.TEKKAI_LIKE));
        }
        List targets2 = this.rangeComponent.getTargetsInArea(entity, 12.0f);
        targets2.remove(entity);
        source = (AbilityDamageSource)ModDamageSource.causeAbilityDamage((LivingEntity)entity, (AbilityCore)this.getCore()).setFistDamage();
        for (LivingEntity target : targets2) {
            if (this.hitTrackerComponent.canHit((Entity)target) && entity.func_70685_l((Entity)target) && !this.dealDamageComponent.hurtTarget(entity, target, 15.0f, (DamageSource)source)) continue;
        }
        if (!entity.field_70170_p.field_72995_K) {
            if (targets.size() > 0) {
                ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
            }
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10));
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 30, 0));
        Vector3d speed = WyHelper.propulsion((LivingEntity)entity, (double)1.0, (double)1.0);
        AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)4.0, (double)speed.field_72449_c);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        IAbilityData props;
        HoverBootsAbility hoverBootsAbility;
        boolean activeHover;
        if (this.continuousComponent.getContinueTime() < 30.0f && this.continuousComponent.getContinueTime() % 5.0f == 0.0f) {
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GEPPO_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.75f);
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.GEPPO.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        }
        boolean bl = activeHover = (hoverBootsAbility = (HoverBootsAbility)(props = AbilityDataCapability.get((LivingEntity)entity)).getEquippedAbility(HoverBootsAbility.INSTANCE)) != null && hoverBootsAbility.isContinuous();
        if (activeHover) {
            hoverBootsAbility.stop(entity, true);
        }
        List targets = this.rangeComponent.getTargetsInArea(entity, 3.0f);
        targets.remove(entity);
        if (this.continuousComponent.getContinueTime() >= 30.0f) {
            Vector3d speed = entity.func_70040_Z().func_216372_d(6.75, 1.0, 6.75);
            AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)-5.0, (double)speed.field_72449_c);
            for (LivingEntity target : targets) {
                this.dealDamageComponent.hurtTarget(entity, target, 45.0f);
                target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 20, 0, false, false));
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60, 0, false, false));
            }
            ExplosionAbility explosion = AbilityHelper.newExplosion(null, (World)entity.field_70170_p, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (float)4.0f);
            explosion.setExplosionSound(true);
            explosion.setDamageEntities(false);
            explosion.setDamageOwner(false);
            if (DevilFruitHelper.getDifferenceToFloor((Entity)entity) > 3.0) {
                explosion.setDestroyBlocks(true);
            } else {
                explosion.setDestroyBlocks(false);
            }
            explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(3));
            explosion.doExplosion();
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 800.0f);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getSubRace().equals("stealth_black");
    }
}

