/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman.stealthblack;

import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class InvisibleMenaceAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"invisible_menace", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user goes invisible occasionally, being able to do anything they dreamed of.", null)});
    private static final int SB_CONTINUITY_THRESHOLD = 300;
    private static final int SB_MIN_COOLDOWN = 200;
    private static final int SB_MAX_COOLDOWN = 600;
    public static final AbilityCore<InvisibleMenaceAbility> INSTANCE = new AbilityCore.Builder("Invisible Menace", AbilityCategory.RACIAL, InvisibleMenaceAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip((float)200.0f), CooldownComponent.getTooltip((float)200.0f, (float)600.0f)}).setUnlockCheck(InvisibleMenaceAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.STEALTH_BLACK.get(), new MorphInfo[0]);

    public InvisibleMenaceAbility(AbilityCore<InvisibleMenaceAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.continuousComponent, this.requireMorphComponent});
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 200.0f);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.VANISH.get(), 10, 0, false, false));
        Vector3d look = entity.func_70040_Z().func_216372_d(2.0, entity.func_70040_Z().field_72448_b >= 0.0 ? 0.0 : 0.6, 2.0);
        if (entity.field_191988_bg < 0.0f) {
            look = look.func_216372_d(-1.0, 1.0, -1.0);
        }
        if (entity.func_70090_H()) {
            look = look.func_216372_d(0.75, 0.5, 0.75);
        }
        AbilityHelper.setDeltaMovement((Entity)entity, (Vector3d)look);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 4.0f, 1.25f);
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.GEPPO.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)(entity.func_226278_cu_() + 0.5), (double)entity.func_226281_cx_());
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.getContinueTime() % 40.0f == 0.0f) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.VANISH.get(), 10, 0, false, false));
            Vector3d look = entity.func_70040_Z().func_216372_d(2.0, entity.func_70040_Z().field_72448_b >= 0.0 ? 0.0 : 0.6, 2.0);
            if (entity.field_191988_bg < 0.0f) {
                look = look.func_216372_d(-1.0, 1.0, -1.0);
            }
            if (entity.func_70090_H()) {
                look = look.func_216372_d(0.75, 0.5, 0.75);
            }
            AbilityHelper.setDeltaMovement((Entity)entity, (Vector3d)look);
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 4.0f, 1.25f);
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.GEPPO.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)(entity.func_226278_cu_() + 0.5), (double)entity.func_226281_cx_());
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 200.0f + this.continuousComponent.getContinueTime() * 2.0f);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getSubRace().equals("stealth_black");
    }
}

