/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman.sparklingred;

import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.entities.projectiles.modifiedhuman.SparkingValkyrieProjectile;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class SparklingValkyrieAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"sparkling_valkyrie", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user fires a barrage of small sparkling projectiles at their enemies.", null)});
    private static final int COOLDOWN = 360;
    public static final AbilityCore<SparklingValkyrieAbility> INSTANCE = new AbilityCore.Builder("Sparkling Valkyrie", AbilityCategory.RACIAL, SparklingValkyrieAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)360.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.EXPLOSION).setUnlockCheck(SparklingValkyrieAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent((IAbility)this).addTriggerEvent(this::repeaterTriggerEvent).addStopEvent(this::repeaterStopEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.SPARKLING_RED.get(), new MorphInfo[0]);

    public SparklingValkyrieAbility(AbilityCore<SparklingValkyrieAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.requireMorphComponent, this.continuousComponent, this.repeaterComponent, this.animationComponent, this.projectileComponent});
        super.addCanUseCheck(AbilityLimits::usingBrawler);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
        } else {
            this.continuousComponent.triggerContinuity(entity);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.animationComponent.start(entity, ModAnimations.CROSSED_ARMS);
            this.repeaterComponent.start(entity, 30, 3);
        }
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1, false, false));
        AbilityHelper.slowEntityFall((LivingEntity)entity);
    }

    private void repeaterTriggerEvent(LivingEntity entity, IAbility ability) {
        if (super.canUse(entity).isFail() || AbilityLimits.cancelBrawler(entity)) {
            this.repeaterComponent.stop(entity);
        }
        this.projectileComponent.shoot(entity, 8.5f, 15.0f);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PIKA_SFX.get(), SoundCategory.PLAYERS, 2.0f, 2.0f);
    }

    private void repeaterStopEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 360.0f);
    }

    private SparkingValkyrieProjectile createProjectile(LivingEntity entity) {
        SparkingValkyrieProjectile proj = new SparkingValkyrieProjectile(entity.field_70170_p, entity, this);
        return proj;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getSubRace().equals("sparkling_red");
    }
}

