/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman.sparklingred;

import java.util.UUID;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.ModifiedHumanHelper;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SparklingStrikeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"sparkling_strike", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user punches with small explosions. (55%)", null)});
    private int SS_HOLDTIME = 400;
    private int SS_COOLDOWN = 500;
    public static final AbilityCore<SparklingStrikeAbility> INSTANCE = new AbilityCore.Builder("Sparkling Strike", AbilityCategory.RACIAL, SparklingStrikeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)35.0f), CooldownComponent.getTooltip((float)100.0f, (float)500.0f), ChangeStatsComponent.getTooltip()}).setSourceType(new SourceType[]{SourceType.FIST}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceElement(SourceElement.EXPLOSION).setUnlockCheck(SparklingStrikeAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::onContinuityTick).addEndEvent(this::endContinuityEvent);
    private final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addOnHitEvent(this::hitEvent);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("7bd10467-5a28-4788-a215-0f303bf576a6"), INSTANCE, "Sparkling Strike Punch Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier REACH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("fdf1e2f5-7f0f-4770-afea-f0d508d04c87"), INSTANCE, "Sparkling Strike Reach Modifier", 0.5, AttributeModifier.Operation.ADDITION);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.SPARKLING_RED.get(), new MorphInfo[0]);

    public SparklingStrikeAbility(AbilityCore<SparklingStrikeAbility> core) {
        super(core);
        this.isNew = true;
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER);
        this.addComponents(new AbilityComponent[]{this.hitTriggerComponent, this.statsComponent, this.continuousComponent, this.requireMorphComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            this.continuousComponent.startContinuity(entity, 400.0f);
        } else {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.statsComponent.applyModifiers(entity);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!ModifiedHumanHelper.hasSuitActive(entity)) {
            this.continuousComponent.stopContinuity(entity);
            this.statsComponent.removeModifiers(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.statsComponent.removeModifiers(entity);
        this.cooldownComponent.startCooldown(entity, 100.0f + this.continuousComponent.getContinueTime());
    }

    private boolean hitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        double ran;
        if (this.continuousComponent.isContinuous() && (ran = Math.random() * 100.0) <= 55.0) {
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 0));
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.SPARKLING_PUNCH.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)(target.func_226278_cu_() + (double)entity.func_70047_e()), (double)target.func_226281_cx_());
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)target.func_226277_ct_(), (double)target.func_226278_cu_(), (double)target.func_226281_cx_(), (float)0.5f);
            explosion.setDamageEntities(true);
            explosion.setDestroyBlocks(false);
            explosion.disableExplosionKnockback();
            explosion.setFireAfterExplosion(false);
            explosion.setExplosionSound(true);
            explosion.setStaticDamage(35.0f);
            explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(1));
            explosion.doExplosion();
        }
        return true;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getSubRace().equals("sparkling_red");
    }
}

