/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman.sparklingred;

import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SparklingFigureAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"sparkling_figure", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user puts both this fists in front of themselves together and launches a devastating blow.", null)});
    private static final float COOLDOWN = 700.0f;
    public static final AbilityCore<SparklingFigureAbility> INSTANCE = new AbilityCore.Builder("Sparkling Figure", AbilityCategory.RACIAL, SparklingFigureAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)700.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceElement(SourceElement.SHOCKWAVE).setSourceType(new SourceType[]{SourceType.FIST}).setSourceElement(SourceElement.EXPLOSION).setUnlockCheck(SparklingFigureAbility::canUnlock).build();
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.SPARKLING_RED.get(), new MorphInfo[0]);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.PUNCH, new AbilityPool2[0]);

    public SparklingFigureAbility(AbilityCore<SparklingFigureAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.requireMorphComponent, this.poolComponent});
    }

    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.SPARKLING_RED.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)(target.func_226278_cu_() + (double)entity.func_70047_e()), (double)target.func_226281_cx_());
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)target.func_226277_ct_(), (double)target.func_226278_cu_(), (double)target.func_226281_cx_(), (float)1.0f);
        explosion.setDamageEntities(false);
        explosion.setDestroyBlocks(false);
        explosion.disableExplosionKnockback();
        explosion.setFireAfterExplosion(false);
        explosion.setExplosionSound(true);
        explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(1));
        explosion.doExplosion();
        Vector3d speed = entity.func_70040_Z().func_72432_b().func_216372_d(4.0, 1.0, 4.0).func_72441_c(0.0, 0.15, 0.0);
        target.func_213317_d(speed);
        target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60, 0));
        return true;
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    public int getUseLimit() {
        return 1;
    }

    public float getPunchDamage() {
        return 60.0f;
    }

    public float getPunchCooldown() {
        return 700.0f;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getSubRace().equals("sparkling_red");
    }
}

