/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman.poisonpink;

import net.MrMagicalCart.cartaddon.init.CartEffects;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class PoisonRemovalAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"poison_removal", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user removes all poison from themselves and receives absorption.", null)});
    private static final int PR_COOLDOWN = 200;
    public static final AbilityCore<PoisonRemovalAbility> INSTANCE = new AbilityCore.Builder("Poison Removal", AbilityCategory.RACIAL, PoisonRemovalAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)200.0f)}).setSourceType(new SourceType[]{SourceType.INDIRECT}).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.POISON).setUnlockCheck(PoisonRemovalAbility::canUnlock).build();
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.POISON_PINK.get(), new MorphInfo[0]);

    public PoisonRemovalAbility(AbilityCore<PoisonRemovalAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.requireMorphComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        int potencyLevel = 0;
        if (entity.func_70644_a(Effects.field_76436_u)) {
            potencyLevel = 1;
            entity.func_195063_d(Effects.field_76436_u);
        }
        if (entity.func_70644_a((Effect)ModEffects.TOKUDAI_CANDLE_POISON.get())) {
            potencyLevel = 3;
            entity.func_195063_d((Effect)ModEffects.TOKUDAI_CANDLE_POISON.get());
        }
        if (entity.func_70644_a((Effect)CartEffects.POISON_PINK.get())) {
            potencyLevel = 3;
            entity.func_195063_d((Effect)CartEffects.POISON_PINK.get());
        }
        if (entity.func_70644_a((Effect)ModEffects.DOKU_POISON.get())) {
            potencyLevel = 4;
            entity.func_195063_d((Effect)ModEffects.DOKU_POISON.get());
        }
        if (potencyLevel != 0) {
            entity.func_195064_c(new EffectInstance(Effects.field_76444_x, 100, potencyLevel));
        } else {
            entity.func_195064_c(new EffectInstance(Effects.field_76444_x, 160, 0));
        }
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getSubRace().equals("poison_pink");
    }
}

