/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman.poisonpink;

import java.util.List;
import net.MrMagicalCart.cartaddon.init.CartEffects;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.KairosekiBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PoisonGuardAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"poison_guard", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user makes a wall out of poison, blocking bullets and inflicting poison.", null)});
    private static final int PG_ON_HOLD = 100;
    private static final int PG_MIN_COOLDOWN = 100;
    private static final int PG_MAX_COOLDOWN = 200;
    public static final AbilityCore<PoisonGuardAbility> INSTANCE = new AbilityCore.Builder("Poison Guard", AbilityCategory.RACIAL, PoisonGuardAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)100.0f, (float)200.0f)}).setSourceType(new SourceType[]{SourceType.INDIRECT}).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.POISON).setUnlockCheck(PoisonGuardAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    protected final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);
    private final Interval particleInterval = new Interval(2);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.POISON_PINK.get(), new MorphInfo[0]);

    public PoisonGuardAbility(AbilityCore<PoisonGuardAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.requireMorphComponent, this.poolComponent, this.rangeComponent, this.hitTrackerComponent, this.dealDamageComponent, this.continuousComponent});
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 100.0f);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.particleInterval.restartIntervalToZero();
        this.hitTrackerComponent.clearHits();
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (super.canUse(entity).isFail()) {
            this.continuousComponent.stopContinuity(entity);
        }
        int range = 2;
        double boxSize = 1.1;
        for (int i = 0; i < range * 2; ++i) {
            double distance = (double)i / 2.0;
            Vector3d lookVec = entity.func_70040_Z();
            Vector3d pos = new Vector3d(entity.func_226277_ct_() + lookVec.field_72450_a * distance, entity.func_226278_cu_() + (double)entity.func_70047_e() + lookVec.field_72448_b * distance, entity.func_226281_cx_() + lookVec.field_72449_c * distance);
            AxisAlignedBB aabb = new AxisAlignedBB(pos.field_72450_a - boxSize, pos.field_72448_b - boxSize, pos.field_72449_c - boxSize, pos.field_72450_a + boxSize, pos.field_72448_b + boxSize * 2.0, pos.field_72449_c + boxSize);
            List targets = entity.field_70170_p.func_175674_a((Entity)entity, aabb, targetx -> targetx != entity);
            for (Entity target : targets) {
                if (target instanceof LivingEntity) {
                    if (!((LivingEntity)target).func_70644_a((Effect)ModEffects.DOKU_POISON.get()) && this.hitTrackerComponent.canHit(target)) {
                        ((LivingEntity)target).func_195064_c(new EffectInstance((Effect)CartEffects.POISON_PINK.get(), 100, 0));
                    }
                    Vector3d dir = entity.func_70040_Z().func_72432_b().func_186678_a(3.0);
                    AbilityHelper.setDeltaMovement((Entity)target, (double)dir.field_72450_a, (double)0.5, (double)dir.field_72449_c);
                    continue;
                }
                if (!(target instanceof AbstractArrowEntity) && !(target instanceof KairosekiBulletProjectile)) {
                    if (!(target instanceof ThrowableEntity)) continue;
                    AbilityHelper.setDeltaMovement((Entity)target, (Vector3d)target.func_213322_ci().func_216372_d(-1.35, 1.0, -1.35));
                    continue;
                }
                target.func_70106_y();
            }
        }
        if (this.particleInterval.canTick()) {
            EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)entity, (double)range);
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.POISON_GUARD.get()), (Entity)entity, (double)trace.func_216347_e().func_82615_a(), (double)entity.func_226278_cu_(), (double)trace.func_216347_e().func_82616_c());
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        float cooldown = 100.0f + this.continuousComponent.getContinueTime();
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getSubRace().equals("poison_pink");
    }
}

