/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman.old;

import java.util.List;
import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.ModifiedHumanHelper;
import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SuitAbilityTwo
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"suit_ability_two", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user removes all poison from themselves and receives absorption.", null), ImmutablePair.of((Object)"The user charges and upon release, creates a devastating explosion.", null), ImmutablePair.of((Object)"The user rapidly moves behind their target, and inflicts a stun kick.", null), ImmutablePair.of((Object)"The user rapidly moves behind their target, and inflicts a blinding kick.", null), ImmutablePair.of((Object)"The user runs forward, and bashes anything in their path.", null)});
    private static final TranslationTextComponent SUIT_ABILITY_TWO = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.suit_ability_two", "Suit Ability Two"));
    private static final TranslationTextComponent POISON_REMOVAL_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.poison_removal", "Poison Removal"));
    private static final TranslationTextComponent SELF_DESTRUCT_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.self_destruct", "Self Destruct"));
    private static final TranslationTextComponent ELE_NEEDLE_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.electricmotive_needle", "Electricmotive Needle"));
    private static final TranslationTextComponent STEALH_KICK_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.stealth_kick", "Stealth Kick"));
    private static final TranslationTextComponent WINCH_BASH_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.winch_bash", "Winch Bash"));
    private static final ResourceLocation SUIT_ABILITY_ICON = new ResourceLocation("cartaddon", "textures/abilities/suit_ability_two.png");
    private static final ResourceLocation POISON_REMOVAL_ICON = new ResourceLocation("cartaddon", "textures/abilities/poison_removal.png");
    private static final ResourceLocation SELF_DESTRUCT_ICON = new ResourceLocation("cartaddon", "textures/abilities/self_destruct.png");
    private static final ResourceLocation ELE_NEEDLE_ICON = new ResourceLocation("cartaddon", "textures/abilities/electricmotive_needle.png");
    private static final ResourceLocation STEALH_KICK_ICON = new ResourceLocation("cartaddon", "textures/abilities/stealth_kick.png");
    private static final ResourceLocation WINCH_BASH_ICON = new ResourceLocation("cartaddon", "textures/abilities/winch_bash.png");
    private static final int PR_COOLDOWN = 200;
    private int explosiveDamage = 60;
    private int maxExplosiveDamage = 120;
    private int explosiveRange = 6;
    private static final int SD_MIN_COOLDOWN = 400;
    private static final int SD_MAX_COOLDOWN = 2400;
    private static final int EM_CHARGE_TIME = 10;
    private static final int EM_COOLDOWN = 240;
    private static final int EM_RANGE = 15;
    private static final int EM_DAMAGE = 40;
    private static final int SK_CHARGE_TIME = 20;
    private static final int SK_COOLDOWN = 400;
    private static final int SK_RANGE = 20;
    private static final int SK_DAMAGE = 25;
    private static final int WB_HOLD_TIME = 30;
    private static final int WB_COOLDOWN = 300;
    private static final float WB_RANGE = 2.0f;
    private static final float WB_DAMAGE = 35.0f;
    public static final AbilityCore<SuitAbilityTwo> INSTANCE = new AbilityCore.Builder("Suit Ability Two", AbilityCategory.RACIAL, SuitAbilityTwo::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> POISON_REMOVAL_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.LIGHT_PURPLE)), (e, a) -> DESCRIPTION[0], CooldownComponent.getTooltip((float)200.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> SELF_DESTRUCT_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), (e, a) -> DESCRIPTION[1], DealDamageComponent.getTooltip((float)60.0f, (float)120.0f), ChargeComponent.getTooltip((float)0.0f, (float)1200.0f), CooldownComponent.getTooltip((float)400.0f, (float)2400.0f), RangeComponent.getTooltip((float)6.0f, (float)30.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> ELE_NEEDLE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE)), (e, a) -> DESCRIPTION[2], DealDamageComponent.getTooltip((float)40.0f), ChargeComponent.getTooltip((float)10.0f), CooldownComponent.getTooltip((float)240.0f), RangeComponent.getTooltip((float)15.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> STEALH_KICK_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), (e, a) -> DESCRIPTION[3], DealDamageComponent.getTooltip((float)20.0f), ChargeComponent.getTooltip((float)20.0f), CooldownComponent.getTooltip((float)400.0f), RangeComponent.getTooltip((float)20.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> WINCH_BASH_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[4], DealDamageComponent.getTooltip((float)45.0f), ContinuousComponent.getTooltip((float)30.0f), CooldownComponent.getTooltip((float)300.0f), RangeComponent.getTooltip((float)2.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceElement(SourceElement.POISON).setUnlockCheck(SuitAbilityTwo::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addTickEvent(this::onChargeTick).addEndEvent(this::endChargeEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final AltModeComponent<Mode> altModeComponent;
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);
    private LivingEntity target;
    private int lastMode = -1;

    public SuitAbilityTwo(AbilityCore<SuitAbilityTwo> core) {
        super(core);
        this.isNew = true;
        this.altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.NONE, true).addChangeModeEvent(this::onAltModeChange);
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.hitTrackerComponent, this.continuousComponent, this.altModeComponent, this.rangeComponent, this.chargeComponent, this.dealDamageComponent, this.animationComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.POISON_PINK) {
            int potencyLevel = 0;
            if (entity.func_70644_a(Effects.field_76436_u)) {
                potencyLevel = 1;
                entity.func_195063_d(Effects.field_76436_u);
            }
            if (entity.func_70644_a((Effect)ModEffects.TOKUDAI_CANDLE_POISON.get())) {
                potencyLevel = 3;
                entity.func_195063_d((Effect)ModEffects.TOKUDAI_CANDLE_POISON.get());
            }
            if (entity.func_70644_a((Effect)ModEffects.DOKU_POISON.get())) {
                potencyLevel = 4;
                entity.func_195063_d((Effect)ModEffects.DOKU_POISON.get());
            }
            if (potencyLevel != 0) {
                entity.func_195064_c(new EffectInstance(Effects.field_76444_x, 100, potencyLevel));
            }
            this.cooldownComponent.startCooldown(entity, 200.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
            if (!this.chargeComponent.isCharging()) {
                this.chargeComponent.startCharging(entity, 1200.0f);
            } else {
                this.chargeComponent.stopCharging(entity);
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.ELECTRIC_SHOCK_BLUE) {
            if (!this.chargeComponent.isCharging()) {
                List targets = this.rangeComponent.getTargetsInLine(entity, 15.0f, 3.0f);
                if (targets.size() > 0) {
                    this.target = (LivingEntity)targets.get(0);
                }
                if (this.target != null) {
                    Vector3d targetLook = VectorHelper.calculateViewVectorFromBodyRot((float)this.target.field_70125_A, (float)this.target.field_70761_aq).func_216372_d(-2.0, 0.0, -2.0);
                    Vector3d newPos = this.target.func_213303_ch().func_178787_e(targetLook);
                    entity.func_195064_c(new EffectInstance((Effect)ModEffects.VANISH.get(), 10, 0, false, false));
                    entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), (int)this.chargeComponent.getMaxChargeTime(), 0, false, false));
                    WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.GORO_LOGIA.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)(entity.func_226278_cu_() + 0.5), (double)entity.func_226281_cx_());
                    entity.func_223102_j(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
                    entity.func_200602_a(EntityAnchorArgument.Type.EYES, this.target.func_213303_ch().func_72441_c(0.0, (double)this.target.func_70047_e(), 0.0));
                    entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
                    this.chargeComponent.startCharging(entity, 10.0f);
                } else {
                    this.cooldownComponent.startCooldown(entity, 240.0f);
                }
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.STEALTH_BLACK) {
            if (!this.chargeComponent.isCharging()) {
                List targets = this.rangeComponent.getTargetsInLine(entity, 20.0f, 3.0f);
                if (targets.size() > 0) {
                    this.target = (LivingEntity)targets.get(0);
                }
                if (this.target != null) {
                    Vector3d targetLook = VectorHelper.calculateViewVectorFromBodyRot((float)this.target.field_70125_A, (float)this.target.field_70761_aq).func_216372_d(-2.0, 0.0, -2.0);
                    Vector3d newPos = this.target.func_213303_ch().func_178787_e(targetLook);
                    entity.func_195064_c(new EffectInstance((Effect)ModEffects.VANISH.get(), 10, 0, false, false));
                    entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), (int)this.chargeComponent.getMaxChargeTime(), 0, false, false));
                    WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.GEPPO.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)(entity.func_226278_cu_() + 0.5), (double)entity.func_226281_cx_());
                    entity.func_223102_j(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
                    entity.func_200602_a(EntityAnchorArgument.Type.EYES, this.target.func_213303_ch().func_72441_c(0.0, (double)this.target.func_70047_e(), 0.0));
                    entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
                    this.target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 0));
                    this.chargeComponent.startCharging(entity, 20.0f);
                } else {
                    this.cooldownComponent.startCooldown(entity, 100.0f);
                }
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN) {
            this.continuousComponent.startContinuity(entity, 30.0f);
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!ModifiedHumanHelper.hasSuitActive(entity)) {
            if (this.lastMode == 2) {
                this.cooldownComponent.startCooldown(entity, 240.0f);
            } else if (this.lastMode == 3) {
                this.cooldownComponent.startCooldown(entity, 400.0f);
            }
            this.chargeComponent.stopCharging(entity);
        }
        if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.SELF_DESTRUCT.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
            if (this.chargeComponent.getChargeTime() % 40.0f == 0.0f) {
                entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), SoundEvents.field_187904_gd, SoundCategory.PLAYERS, 2.0f, 1.0f);
            }
            if (this.chargeComponent.getChargeTime() % 20.0f == 0.0f) {
                ++this.explosiveDamage;
            }
            if (this.chargeComponent.getChargeTime() % 40.0f == 0.0f) {
                ++this.explosiveRange;
            }
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED || this.lastMode == 1) {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (float)this.explosiveRange);
            explosion.setStaticDamage((float)this.explosiveDamage);
            explosion.setExplosionSound(true);
            explosion.setDamageEntities(true);
            explosion.setDamageOwner(true);
            explosion.setDestroyBlocks(true);
            explosion.setFireAfterExplosion(true);
            explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(3));
            explosion.doExplosion();
            this.cooldownComponent.startCooldown(entity, 400.0f + 2000.0f * this.chargeComponent.getChargePercentage());
        } else if (this.altModeComponent.getCurrentMode() == Mode.ELECTRIC_SHOCK_BLUE) {
            if (!entity.field_70170_p.field_72995_K && this.target != null && this.target.func_70089_S() && Math.abs(this.target.func_70032_d((Entity)entity)) < 5.0f) {
                this.animationComponent.start(entity, ModAnimations.PITCH_SPIN, 7);
                entity.func_226292_a_(Hand.MAIN_HAND, true);
                List targets = this.rangeComponent.getTargetsInArea(entity, this.target.func_233580_cy_(), 2.0f);
                for (LivingEntity target : targets) {
                    this.dealDamageComponent.hurtTarget(entity, target, 40.0f);
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60, 0, false, false));
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0, false, false));
                }
            }
            this.target = null;
            this.cooldownComponent.startCooldown(entity, 240.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.STEALTH_BLACK) {
            if (!entity.field_70170_p.field_72995_K && this.target != null && this.target.func_70089_S() && Math.abs(this.target.func_70032_d((Entity)entity)) < 5.0f) {
                this.animationComponent.start(entity, ModAnimations.PITCH_SPIN, 7);
                entity.func_226292_a_(Hand.MAIN_HAND, true);
                List targets = this.rangeComponent.getTargetsInArea(entity, this.target.func_233580_cy_(), 2.0f);
                for (LivingEntity target : targets) {
                    this.dealDamageComponent.hurtTarget(entity, target, 25.0f);
                    target.func_195064_c(new EffectInstance(Effects.field_76440_q, 60, 0, false, false));
                    target.func_195064_c(new EffectInstance(Effects.field_76431_k, 60, 0, false, false));
                }
            }
            this.target = null;
            this.cooldownComponent.startCooldown(entity, 400.0f);
        }
        this.explosiveDamage = 90;
        this.explosiveRange = 6;
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN) {
            this.hitTrackerComponent.clearHits();
            this.animationComponent.start(entity, ModAnimations.CHARGE_PUNCH);
        }
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!ModifiedHumanHelper.hasSuitActive(entity)) {
            this.cooldownComponent.startCooldown(entity, 300.0f);
            this.continuousComponent.stopContinuity(entity);
            this.animationComponent.stop(entity);
        }
        if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN && entity.func_70089_S()) {
            Vector3d look = entity.func_70040_Z();
            Vector3d speed = look.func_216372_d(1.6, 0.0, 1.6);
            entity.func_213315_a(MoverType.SELF, speed);
            List targets = this.rangeComponent.getTargetsInLine(entity, 2.0f, 3.0f);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
                this.dealDamageComponent.hurtTarget(entity, target, 45.0f);
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 100, 0, false, false));
            }
            for (LivingEntity target : this.hitTrackerComponent.getHits()) {
                target.func_70634_a(entity.func_226277_ct_() + look.field_72450_a, entity.func_226278_cu_(), entity.func_226281_cx_() + look.field_72449_c);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN) {
            this.animationComponent.stop(entity);
            this.cooldownComponent.startCooldown(entity, 300.0f);
        }
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.NONE) {
            super.setDisplayIcon(SUIT_ABILITY_ICON);
            super.setDisplayName((ITextComponent)SUIT_ABILITY_TWO);
        } else if (mode == Mode.POISON_PINK) {
            super.setDisplayIcon(POISON_REMOVAL_ICON);
            super.setDisplayName((ITextComponent)POISON_REMOVAL_NAME);
            this.lastMode = 0;
        } else if (mode == Mode.SPARKLING_RED) {
            super.setDisplayIcon(SELF_DESTRUCT_ICON);
            super.setDisplayName((ITextComponent)SELF_DESTRUCT_NAME);
            this.lastMode = 1;
        } else if (mode == Mode.ELECTRIC_SHOCK_BLUE) {
            super.setDisplayIcon(ELE_NEEDLE_ICON);
            super.setDisplayName((ITextComponent)ELE_NEEDLE_NAME);
            this.lastMode = 2;
        } else if (mode == Mode.STEALTH_BLACK) {
            super.setDisplayIcon(STEALH_KICK_ICON);
            super.setDisplayName((ITextComponent)STEALH_KICK_NAME);
            this.lastMode = 3;
        } else if (mode == Mode.WINCH_GREEN) {
            super.setDisplayIcon(WINCH_BASH_ICON);
            super.setDisplayName((ITextComponent)WINCH_BASH_NAME);
            this.lastMode = 4;
        }
    }

    public void switchNone(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.NONE);
    }

    public void switchPoisonPink(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.POISON_PINK);
    }

    public void switchSparklingRed(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.SPARKLING_RED);
    }

    public void switchShockBlue(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.ELECTRIC_SHOCK_BLUE);
    }

    public void switchStealthBlack(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.STEALTH_BLACK);
    }

    public void switchWinchGreen(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.WINCH_GREEN);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getDoriki() >= 4500.0;
    }

    public static enum Mode {
        NONE,
        POISON_PINK,
        SPARKLING_RED,
        ELECTRIC_SHOCK_BLUE,
        STEALTH_BLACK,
        WINCH_GREEN;

    }
}

