/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman.old;

import java.util.UUID;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.ModifiedHumanHelper;
import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.init.CartEffects;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SuitAbilityThree
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"suit_ability_three", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user punches with poison enhanced fists (10%).", null), ImmutablePair.of((Object)"The user punches with small explosions. (35%)", null), ImmutablePair.of((Object)"The user punches with electric stun punches. (5%)", null), ImmutablePair.of((Object)"The user goes into stealth mode, running faster and can inflict slowing on punch. (5%)", null), ImmutablePair.of((Object)"The user increases their punch and reach for a short duration.", null)});
    private static final TranslationTextComponent SUIT_ABILITY_THREE = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.suit_ability_three", "Suit Ability Three"));
    private static final TranslationTextComponent POISON_STRIKE_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.poison_strike", "Poison Strike"));
    private static final TranslationTextComponent SPARKLING_STRIKE_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.sparkling_strike", "Sparkling Strike"));
    private static final TranslationTextComponent SHOCKING_STRIKE_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.shocking_strike", "Shocking Strike"));
    private static final TranslationTextComponent STEALTH_STRIKE_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.stealth_strike", "Stealth Strike"));
    private static final TranslationTextComponent WINCH_STRIKE_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.winch_strike", "Winch Strike"));
    private static final ResourceLocation SUIT_ABILITY_ICON = new ResourceLocation("cartaddon", "textures/abilities/suit_ability_three.png");
    private static final ResourceLocation POISON_STRIKE_ICON = new ResourceLocation("cartaddon", "textures/abilities/poison_strike.png");
    private static final ResourceLocation SPARKLING_STRIKE_ICON = new ResourceLocation("cartaddon", "textures/abilities/sparkling_strike.png");
    private static final ResourceLocation SHOCKING_STRIKE_ICON = new ResourceLocation("cartaddon", "textures/abilities/shocking_strike.png");
    private static final ResourceLocation STEALTH_STRIKE_ICON = new ResourceLocation("cartaddon", "textures/abilities/stealth_strike.png");
    private static final ResourceLocation WINCH_STRIKE_ICON = new ResourceLocation("cartaddon", "textures/abilities/winch_strike.png");
    private int PS_HOLDTIME = 400;
    private int PS_COOLDOWN = 400;
    private int SS_HOLDTIME = 400;
    private int SS_COOLDOWN = 400;
    private int TS_HOLDTIME = 400;
    private int TS_COOLDOWN = 400;
    private int STS_HOLDTIME = 400;
    private int STS_COOLDOWN = 400;
    private int WS_HOLDTIME = 400;
    private int WS_COOLDOWN = 400;
    public static final AbilityCore<SuitAbilityThree> INSTANCE = new AbilityCore.Builder("Suit Ability Three", AbilityCategory.RACIAL, SuitAbilityThree::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> POISON_STRIKE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.LIGHT_PURPLE)), (e, a) -> DESCRIPTION[0], ContinuousComponent.getTooltip((float)400.0f), CooldownComponent.getTooltip((float)100.0f, (float)500.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> SPARKLING_STRIKE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), (e, a) -> DESCRIPTION[1], ContinuousComponent.getTooltip((float)400.0f), CooldownComponent.getTooltip((float)100.0f, (float)500.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> SHOCKING_STRIKE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE)), (e, a) -> DESCRIPTION[2], ContinuousComponent.getTooltip((float)400.0f), CooldownComponent.getTooltip((float)100.0f, (float)500.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> STEALTH_STRIKE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), (e, a) -> DESCRIPTION[3], ContinuousComponent.getTooltip((float)400.0f), CooldownComponent.getTooltip((float)100.0f, (float)500.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> WINCH_STRIKE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[4], ContinuousComponent.getTooltip((float)400.0f), CooldownComponent.getTooltip((float)100.0f, (float)500.0f), ChangeStatsComponent.getTooltip()}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceElement(SourceElement.POISON).setUnlockCheck(SuitAbilityThree::canUnlock).build();
    private final AltModeComponent<Mode> altModeComponent;
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::onContinuityTick).addEndEvent(this::endContinuityEvent);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addOnHitEvent(this::hitEvent);
    private final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("cabb0039-aed9-4bb0-a846-49744e703579"), INSTANCE, "Winch Green Punch Modifier", 5.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier REACH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("0907e37c-15dd-4c66-83bd-b25d837dfee5"), INSTANCE, "Winch Green Reach Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private int lastMode = -1;

    public SuitAbilityThree(AbilityCore<SuitAbilityThree> core) {
        super(core);
        this.isNew = true;
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER);
        this.altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.NONE, true).addChangeModeEvent(this::onAltModeChange);
        this.addComponents(new AbilityComponent[]{this.altModeComponent, this.hitTriggerComponent, this.statsComponent, this.continuousComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.POISON_PINK) {
            if (!this.continuousComponent.isContinuous()) {
                this.continuousComponent.startContinuity(entity, 400.0f);
            } else {
                this.continuousComponent.stopContinuity(entity);
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
            if (!this.continuousComponent.isContinuous()) {
                this.continuousComponent.startContinuity(entity, 400.0f);
            } else {
                this.continuousComponent.stopContinuity(entity);
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.ELECTRIC_SHOCK_BLUE) {
            if (!this.continuousComponent.isContinuous()) {
                this.continuousComponent.startContinuity(entity, 400.0f);
            } else {
                this.continuousComponent.stopContinuity(entity);
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.STEALTH_BLACK) {
            if (!this.continuousComponent.isContinuous()) {
                this.continuousComponent.startContinuity(entity, 400.0f);
            } else {
                this.continuousComponent.stopContinuity(entity);
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN) {
            if (!this.continuousComponent.isContinuous()) {
                this.continuousComponent.startContinuity(entity, 400.0f);
            } else {
                this.continuousComponent.stopContinuity(entity);
            }
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN) {
            this.statsComponent.applyModifiers(entity);
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!ModifiedHumanHelper.hasSuitActive(entity)) {
            this.continuousComponent.stopContinuity(entity);
            this.statsComponent.removeModifiers(entity);
        }
        if (this.altModeComponent.getCurrentMode() == Mode.STEALTH_BLACK) {
            entity.func_195064_c(new EffectInstance((Effect)CartEffects.STEALTH.get(), 20, 0, false, false));
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN || this.lastMode == 4) {
            this.statsComponent.removeModifiers(entity);
        }
        this.cooldownComponent.startCooldown(entity, 100.0f + this.continuousComponent.getContinueTime());
    }

    private boolean hitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            double ran = Math.random() * 100.0;
            if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
                source.bypassLogia().func_94540_d();
            }
            if (this.altModeComponent.getCurrentMode() == Mode.ELECTRIC_SHOCK_BLUE) {
                source.bypassLogia().setInternal().setPiercing(0.85f);
            }
            if (ran <= 35.0 && this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
                target.func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 0));
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.SPARKLING_PUNCH.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)(target.func_226278_cu_() + (double)entity.func_70047_e()), (double)target.func_226281_cx_());
                ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)target.func_226277_ct_(), (double)target.func_226278_cu_(), (double)target.func_226281_cx_(), (float)0.5f);
                explosion.setDamageEntities(true);
                explosion.setDestroyBlocks(false);
                explosion.disableExplosionKnockback();
                explosion.setFireAfterExplosion(false);
                explosion.setExplosionSound(true);
                explosion.setStaticDamage(30.0f);
                explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(1));
                explosion.doExplosion();
            }
            if (ran <= 10.0 && this.altModeComponent.getCurrentMode() == Mode.POISON_PINK) {
                target.func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 2));
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.POISON_PUNCH.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)(target.func_226278_cu_() + (double)entity.func_70047_e()), (double)target.func_226281_cx_());
            }
            if (ran <= 5.0) {
                if (this.altModeComponent.getCurrentMode() == Mode.ELECTRIC_SHOCK_BLUE) {
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0));
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 10, 0));
                    WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.SHOCK_PUNCH.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)(target.func_226278_cu_() + (double)entity.func_70047_e()), (double)target.func_226281_cx_());
                }
                if (this.altModeComponent.getCurrentMode() == Mode.STEALTH_BLACK) {
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60, 0));
                }
            }
            if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN) {
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.WINCH_PUNCH.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)(target.func_226278_cu_() + (double)entity.func_70047_e()), (double)target.func_226281_cx_());
            }
        }
        return true;
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.NONE) {
            super.setDisplayIcon(SUIT_ABILITY_ICON);
            super.setDisplayName((ITextComponent)SUIT_ABILITY_THREE);
        } else if (mode == Mode.POISON_PINK) {
            super.setDisplayIcon(POISON_STRIKE_ICON);
            super.setDisplayName((ITextComponent)POISON_STRIKE_NAME);
            this.lastMode = 0;
        } else if (mode == Mode.SPARKLING_RED) {
            super.setDisplayIcon(SPARKLING_STRIKE_ICON);
            super.setDisplayName((ITextComponent)SPARKLING_STRIKE_NAME);
            this.lastMode = 1;
        } else if (mode == Mode.ELECTRIC_SHOCK_BLUE) {
            super.setDisplayIcon(SHOCKING_STRIKE_ICON);
            super.setDisplayName((ITextComponent)SHOCKING_STRIKE_NAME);
            this.lastMode = 2;
        } else if (mode == Mode.STEALTH_BLACK) {
            super.setDisplayIcon(STEALTH_STRIKE_ICON);
            super.setDisplayName((ITextComponent)STEALTH_STRIKE_NAME);
            this.lastMode = 3;
        } else if (mode == Mode.WINCH_GREEN) {
            super.setDisplayIcon(WINCH_STRIKE_ICON);
            super.setDisplayName((ITextComponent)WINCH_STRIKE_NAME);
            this.lastMode = 4;
        }
    }

    public void switchNone(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.NONE);
    }

    public void switchPoisonPink(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.POISON_PINK);
    }

    public void switchSparklingRed(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.SPARKLING_RED);
    }

    public void switchShockBlue(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.ELECTRIC_SHOCK_BLUE);
    }

    public void switchStealthBlack(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.STEALTH_BLACK);
    }

    public void switchWinchGreen(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.WINCH_GREEN);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getDoriki() >= 7000.0;
    }

    public static enum Mode {
        NONE,
        POISON_PINK,
        SPARKLING_RED,
        ELECTRIC_SHOCK_BLUE,
        STEALTH_BLACK,
        WINCH_GREEN;

    }
}

