/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman.old;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.ModifiedHumanHelper;
import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.MrMagicalCart.cartaddon.particles.effects.modifiedhuman.ElectricFieldParticleEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.KairosekiBulletProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.NormalBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SuitAbilityOne
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"suit_ability_one", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user makes a wall out of poison, blocking bullets and inflicting poison.", null), ImmutablePair.of((Object)"The user puts both this fists in front of themselves together and launches a devastating blow.", null), ImmutablePair.of((Object)"The user generates electricity around themselves, stunning all those nearby.", null), ImmutablePair.of((Object)"The user goes invisible for a duration of time, being able to do anything they dreamed of.", null), ImmutablePair.of((Object)"The user grabs and holds their opponent in front of themselves.", null)});
    private static final TranslationTextComponent SUIT_ABILITY_ONE = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.suit_ability_one", "Suit Ability One"));
    private static final TranslationTextComponent POISON_GUARD_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.poison_guard", "Poison Guard"));
    private static final TranslationTextComponent SPARKLING_FIGURE_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.sparkling_figure", "Sparkling Figure"));
    private static final TranslationTextComponent ELECTRIC_FIELD_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.electric_field", "Electric Field"));
    private static final TranslationTextComponent INVISIBLE_MENACE_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.invisible_menace", "Invisible Menace"));
    private static final TranslationTextComponent WINCH_GRAB_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.winch_grab", "Winch Grab"));
    private static final ResourceLocation SUIT_ABILITY_ICON = new ResourceLocation("cartaddon", "textures/abilities/suit_ability_one.png");
    private static final ResourceLocation POISON_GUARD_ICON = new ResourceLocation("cartaddon", "textures/abilities/poison_guard.png");
    private static final ResourceLocation SPARKLING_FIGURE_ICON = new ResourceLocation("cartaddon", "textures/abilities/sparkling_figure.png");
    private static final ResourceLocation ELECTRIC_FIELD_ICON = new ResourceLocation("cartaddon", "textures/abilities/electric_field.png");
    private static final ResourceLocation INVISIBLE_MENACE_ICON = new ResourceLocation("cartaddon", "textures/abilities/invisible_menace.png");
    private static final ResourceLocation WINCH_GRAB_ICON = new ResourceLocation("cartaddon", "textures/abilities/winch_grab.png");
    private static final int PG_ON_HOLD = 100;
    private static final int PG_MIN_COOLDOWN = 100;
    private static final int PG_MAX_COOLDOWN = 200;
    private static final int SF_DAMAGE = 60;
    private static final int SF_COOLDOWN = 700;
    private static final int EF_CHARGE_TIME = 40;
    private static final int EF_MIN_COOLDOWN = 300;
    private static final int EF_MAX_COOLDOWN = 400;
    private static final int EF_RANGE = 2;
    private static final int SB_CONTINUITY_THRESHOLD = 100;
    private static final int SB_MIN_COOLDOWN = 200;
    private static final int SB_MAX_COOLDOWN = 400;
    private static final int WG_PULL_TIME = 200;
    private static final int WG_CHARGE_TIME = 100;
    private static final int WG_COOLDOWN = 260;
    public static final AbilityCore<SuitAbilityOne> INSTANCE;
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final AltModeComponent<Mode> altModeComponent;
    protected final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addTryHitEvent(200, this::tryHitEvent).addOnHitEvent(200, this::onHitEvent);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    protected final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);
    private static final ElectricFieldParticleEffect.Details DETAILS;
    private final Interval particleInterval = new Interval(2);
    private final Interval clearHitsInterval = new Interval(20);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);
    private final GrabEntityComponent grabComponent = new GrabEntityComponent((IAbility)this, true, true, true, 2.0f).addPullStartEvent(this::onPullStart).addPullEndEvent(this::onPullEnd);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private int uses = 0;
    private boolean markForStopping;
    private static final AbilityAttributeModifier STRENGTH_MODIFIER;
    private int lastMode = -1;

    public SuitAbilityOne(AbilityCore<SuitAbilityOne> core) {
        super(core);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER);
        this.altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.NONE, true).addChangeModeEvent(this::onAltModeChange);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.poolComponent, this.grabComponent, this.animationComponent, this.statsComponent, this.chargeComponent, this.hitTriggerComponent, this.rangeComponent, this.chargeComponent, this.hitTrackerComponent, this.dealDamageComponent, this.altModeComponent, this.continuousComponent});
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() != Mode.NONE) {
            if (this.altModeComponent.getCurrentMode() == Mode.POISON_PINK) {
                this.continuousComponent.triggerContinuity(entity, 100.0f);
            } else if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
                this.continuousComponent.triggerContinuity(entity);
            } else if (this.altModeComponent.getCurrentMode() == Mode.ELECTRIC_SHOCK_BLUE) {
                if (!this.chargeComponent.isCharging()) {
                    this.particleInterval.restartIntervalToZero();
                    this.chargeComponent.startCharging(entity, 40.0f);
                } else {
                    this.chargeComponent.stopCharging(entity);
                }
            } else if (this.altModeComponent.getCurrentMode() == Mode.STEALTH_BLACK) {
                this.continuousComponent.triggerContinuity(entity, 100.0f);
            } else if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN && !this.chargeComponent.isCharging()) {
                if (this.continuousComponent.isContinuous()) {
                    this.grabComponent.release(entity);
                    this.continuousComponent.stopContinuity(entity);
                } else if (this.grabComponent.getState() == GrabEntityComponent.GrabState.IDLE && this.grabComponent.grabNearest(entity, 4.5f, 2.0f, false)) {
                    this.grabComponent.triggerPulling(entity);
                } else {
                    this.cooldownComponent.startCooldown(entity, 15.0f);
                }
            }
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN) {
            this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM);
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!ModifiedHumanHelper.hasSuitActive(entity)) {
            if (this.lastMode == 2) {
                this.cooldownComponent.startCooldown(entity, 300.0f);
            }
            this.chargeComponent.stopCharging(entity);
            this.statsComponent.removeModifiers(entity);
            if (this.grabComponent.hasGrabbedEntity()) {
                this.grabComponent.release(entity);
            }
        }
        if (this.altModeComponent.getCurrentMode() == Mode.ELECTRIC_SHOCK_BLUE) {
            if (!entity.field_70170_p.field_72995_K) {
                entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1));
                if (this.particleInterval.canTick()) {
                    DETAILS.setRange(2);
                    DETAILS.setSize(2.0f);
                    WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.ELECTRIC_FIELD.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (ParticleEffect.Details)DETAILS);
                }
                float range = this.rangeComponent.getBonusManager().applyBonus(2.0f);
                List targets = WyHelper.getNearbyEntities((Vector3d)entity.func_213303_ch(), (IWorld)entity.field_70170_p, (double)range, (Predicate)null, (Class[])new Class[]{Entity.class});
                for (Entity target : targets) {
                    if (target instanceof LivingEntity && target != entity) {
                        ((LivingEntity)target).func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 1));
                        ((LivingEntity)target).func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0));
                        ((LivingEntity)target).func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 20, 0));
                        ((LivingEntity)target).func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 20, 0));
                        continue;
                    }
                    if (!(target instanceof AbilityProjectileEntity)) continue;
                    AbilityProjectileEntity abilityProj = (AbilityProjectileEntity)target;
                    if (abilityProj.getDamageSource().isPhysical()) {
                        LivingEntity thrower = abilityProj.getThrower();
                        if (thrower == null || thrower == entity) continue;
                        target.func_70106_y();
                        continue;
                    }
                    target.func_70106_y();
                }
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN && !entity.field_70170_p.field_72995_K) {
            if (!super.canUse(entity).isFail() && this.grabComponent.canContinueGrab(entity)) {
                LivingEntity target = this.grabComponent.getGrabbedEntity();
                DamageSource source = ModDamageSource.causeAbilityDamage((LivingEntity)entity, (IAbility)this).setInternal().func_151518_m();
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.WINCH_GRAB.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)(target.func_226278_cu_() + (double)entity.func_70047_e()), (double)target.func_226281_cx_());
            } else {
                this.chargeComponent.stopCharging(entity);
            }
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.ELECTRIC_SHOCK_BLUE) {
            if (!entity.field_70170_p.field_72995_K) {
                entity.field_70170_p.func_184148_a((PlayerEntity)null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187752_dd, SoundCategory.WEATHER, 2.0f, 0.5f + entity.func_70681_au().nextFloat() * 0.2f);
                float cooldown = Math.max(300.0f, 400.0f * this.chargeComponent.getChargePercentage());
                this.cooldownComponent.startCooldown(entity, cooldown);
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN) {
            if (this.grabComponent.hasGrabbedEntity()) {
                DamageSource source;
                LivingEntity target = this.grabComponent.getGrabbedEntity();
                if (this.dealDamageComponent.hurtTarget(entity, target, 7.0f, source = ModDamageSource.causeAbilityDamage((LivingEntity)entity, (IAbility)this).setInternal().func_151518_m())) {
                    target.func_195064_c(new EffectInstance(Effects.field_76437_t, 100, 0, false, false));
                    target.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 1, false, false));
                    target.func_195064_c(new EffectInstance(Effects.field_76419_f, 100, 1, false, false));
                }
                this.grabComponent.release(entity);
            }
            this.animationComponent.stop(entity);
            this.cooldownComponent.startCooldown(entity, 260.0f);
        }
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.POISON_PINK) {
            this.particleInterval.restartIntervalToZero();
            this.hitTrackerComponent.clearHits();
        } else if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
            this.uses = 0;
            this.markForStopping = false;
            this.statsComponent.applyModifiers(entity);
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!ModifiedHumanHelper.hasSuitActive(entity)) {
            if (this.lastMode == 4) {
                this.cooldownComponent.startCooldown(entity, 400.0f);
            }
            this.continuousComponent.stopContinuity(entity);
            this.statsComponent.removeModifiers(entity);
            if (this.grabComponent.hasGrabbedEntity()) {
                this.grabComponent.release(entity);
            }
        }
        if (this.altModeComponent.getCurrentMode() == Mode.POISON_PINK) {
            if (super.canUse(entity).isFail()) {
                this.continuousComponent.stopContinuity(entity);
            }
            int range = 2;
            double boxSize = 1.1;
            for (int i = 0; i < range * 2; ++i) {
                double distance = (double)i / 2.0;
                Vector3d lookVec = entity.func_70040_Z();
                Vector3d pos = new Vector3d(entity.func_226277_ct_() + lookVec.field_72450_a * distance, entity.func_226278_cu_() + (double)entity.func_70047_e() + lookVec.field_72448_b * distance, entity.func_226281_cx_() + lookVec.field_72449_c * distance);
                AxisAlignedBB aabb = new AxisAlignedBB(pos.field_72450_a - boxSize, pos.field_72448_b - boxSize, pos.field_72449_c - boxSize, pos.field_72450_a + boxSize, pos.field_72448_b + boxSize * 2.0, pos.field_72449_c + boxSize);
                List targets = entity.field_70170_p.func_175674_a((Entity)entity, aabb, targetx -> targetx != entity);
                for (Entity target : targets) {
                    if (target instanceof LivingEntity) {
                        if (!((LivingEntity)target).func_70644_a((Effect)ModEffects.DOKU_POISON.get()) && this.hitTrackerComponent.canHit(target)) {
                            ((LivingEntity)target).func_195064_c(new EffectInstance((Effect)ModEffects.DOKU_POISON.get(), 80, 0));
                        }
                        Vector3d dir = entity.func_70040_Z().func_72432_b().func_186678_a(3.0);
                        AbilityHelper.setDeltaMovement((Entity)target, (double)dir.field_72450_a, (double)0.5, (double)dir.field_72449_c);
                        continue;
                    }
                    if (!(target instanceof AbstractArrowEntity || target instanceof KairosekiBulletProjectile || target instanceof NormalBulletProjectile)) {
                        if (!(target instanceof ThrowableEntity)) continue;
                        AbilityHelper.setDeltaMovement((Entity)target, (Vector3d)target.func_213322_ci().func_216372_d(-1.35, 1.0, -1.35));
                        continue;
                    }
                    target.func_70106_y();
                }
            }
            if (this.particleInterval.canTick()) {
                EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)entity, (double)range);
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.POISON_GUARD.get()), (Entity)entity, (double)trace.func_216347_e().func_82615_a(), (double)entity.func_226278_cu_(), (double)trace.func_216347_e().func_82616_c());
            }
            if (this.clearHitsInterval.canTick()) {
                this.hitTrackerComponent.clearHits();
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
            if (this.markForStopping) {
                this.continuousComponent.stopContinuity(entity);
                this.markForStopping = false;
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.STEALTH_BLACK) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.VANISH.get(), 10, 0, false, false));
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.POISON_PINK || this.lastMode == 0) {
            float cooldown = 100.0f + this.continuousComponent.getContinueTime();
            this.cooldownComponent.startCooldown(entity, cooldown);
        } else if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED || this.lastMode == 1) {
            this.statsComponent.removeModifiers(entity);
            this.cooldownComponent.startCooldown(entity, 700.0f);
        } else if (this.altModeComponent.getCurrentMode() != Mode.ELECTRIC_SHOCK_BLUE) {
            if (this.altModeComponent.getCurrentMode() == Mode.STEALTH_BLACK || this.lastMode == 3) {
                this.cooldownComponent.startCooldown(entity, 200.0f + this.continuousComponent.getContinueTime() * 2.0f);
            } else if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN && !entity.field_70170_p.field_72995_K) {
                if (this.grabComponent.getState() != GrabEntityComponent.GrabState.GRABBED) {
                    this.grabComponent.release(entity);
                }
                if (!this.grabComponent.canContinueGrab(entity)) {
                    this.cooldownComponent.startCooldown(entity, 260.0f);
                }
            }
        }
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.NONE) {
            super.setDisplayIcon(SUIT_ABILITY_ICON);
            super.setDisplayName((ITextComponent)SUIT_ABILITY_ONE);
        } else if (mode == Mode.POISON_PINK) {
            super.setDisplayIcon(POISON_GUARD_ICON);
            super.setDisplayName((ITextComponent)POISON_GUARD_NAME);
            this.lastMode = 0;
        } else if (mode == Mode.SPARKLING_RED) {
            super.setDisplayIcon(SPARKLING_FIGURE_ICON);
            super.setDisplayName((ITextComponent)SPARKLING_FIGURE_NAME);
            this.lastMode = 1;
        } else if (mode == Mode.ELECTRIC_SHOCK_BLUE) {
            super.setDisplayName((ITextComponent)ELECTRIC_FIELD_NAME);
            super.setDisplayIcon(ELECTRIC_FIELD_ICON);
            this.lastMode = 2;
        } else if (mode == Mode.STEALTH_BLACK) {
            super.setDisplayIcon(INVISIBLE_MENACE_ICON);
            super.setDisplayName((ITextComponent)INVISIBLE_MENACE_NAME);
            this.lastMode = 3;
        } else if (mode == Mode.WINCH_GREEN) {
            super.setDisplayIcon(WINCH_GRAB_ICON);
            super.setDisplayName((ITextComponent)WINCH_GRAB_NAME);
            this.lastMode = 4;
        }
    }

    public void switchNone(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.NONE);
    }

    public void switchPoisonPink(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.POISON_PINK);
    }

    public void switchSparklingRed(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.SPARKLING_RED);
    }

    public void switchShockBlue(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.ELECTRIC_SHOCK_BLUE);
    }

    public void switchStealthBlack(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.STEALTH_BLACK);
    }

    public void switchWinchGreen(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.WINCH_GREEN);
    }

    private HitTriggerComponent.HitResult tryHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        return this.canActivate().test(entity) ? HitTriggerComponent.HitResult.HIT : HitTriggerComponent.HitResult.PASS;
    }

    private boolean onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        boolean result = true;
        if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
            if (!source.isBlocked()) {
                result = this.onHitEffect(entity, target, source);
            }
            this.increaseUses();
        } else if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN) {
            if (this.continuousComponent.isContinuous() && !this.grabComponent.hasGrabbedEntity()) {
                if (this.grabComponent.grabManually(entity, target)) {
                    this.grabComponent.startPulling(entity);
                }
                target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 1));
                return false;
            }
            return true;
        }
        return result;
    }

    public void increaseUses() {
        ++this.uses;
        if (this.getUseLimit() > 0 && this.uses >= this.getUseLimit()) {
            this.markForStopping = true;
        }
    }

    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.SPARKLING_RED.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)(target.func_226278_cu_() + (double)entity.func_70047_e()), (double)target.func_226281_cx_());
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)target.func_226277_ct_(), (double)target.func_226278_cu_(), (double)target.func_226281_cx_(), (float)1.0f);
            explosion.setDamageEntities(false);
            explosion.setDestroyBlocks(false);
            explosion.disableExplosionKnockback();
            explosion.setFireAfterExplosion(false);
            explosion.setExplosionSound(true);
            explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(1));
            explosion.doExplosion();
            Vector3d speed = entity.func_70040_Z().func_72432_b().func_216372_d(4.0, 1.0, 4.0).func_72441_c(0.0, 0.15, 0.0);
            target.func_213317_d(speed);
            target.func_195064_c(new EffectInstance(Effects.field_76440_q, 40, 0));
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, 40, 1));
        }
        return true;
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous();
    }

    public int getUseLimit() {
        return 1;
    }

    public void onPullStart(LivingEntity entity, IAbility ability) {
        this.continuousComponent.setThresholdTime(entity, 200.0f);
    }

    public void onPullEnd(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        if (this.grabComponent.canContinueGrab(entity)) {
            this.chargeComponent.startCharging(entity, 60.0f);
        }
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getDoriki() >= 2500.0;
    }

    static {
        DETAILS = new ElectricFieldParticleEffect.Details();
        INSTANCE = new AbilityCore.Builder("Suit Ability One", AbilityCategory.RACIAL, SuitAbilityOne::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> POISON_GUARD_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.LIGHT_PURPLE)), (e, a) -> DESCRIPTION[0], ContinuousComponent.getTooltip((float)100.0f), CooldownComponent.getTooltip((float)100.0f, (float)200.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> SPARKLING_FIGURE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), (e, a) -> DESCRIPTION[1], DealDamageComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)700.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> ELECTRIC_FIELD_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE)), (e, a) -> DESCRIPTION[2], ChargeComponent.getTooltip((float)40.0f), CooldownComponent.getTooltip((float)300.0f, (float)400.0f), RangeComponent.getTooltip((float)2.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> INVISIBLE_MENACE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), (e, a) -> DESCRIPTION[3], ContinuousComponent.getTooltip((float)100.0f), CooldownComponent.getTooltip((float)200.0f, (float)400.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> WINCH_GRAB_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[4], ChargeComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)260.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceElement(SourceElement.POISON).setUnlockCheck(SuitAbilityOne::canUnlock).build();
        STRENGTH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("c43b86bf-47e9-4b2b-8673-f0985d9fab17"), INSTANCE, "Sparkling Figure Punch Modifier", 60.0, AttributeModifier.Operation.ADDITION);
    }

    public static enum Mode {
        NONE,
        POISON_PINK,
        SPARKLING_RED,
        ELECTRIC_SHOCK_BLUE,
        STEALTH_BLACK,
        WINCH_GREEN;

    }
}

