/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman.old;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.HoverBootsAbility;
import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.ModifiedHumanHelper;
import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.old.SuitAbilityThree;
import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.entities.projectiles.modifiedhuman.PinkHornetProjectile;
import net.MrMagicalCart.cartaddon.entities.projectiles.modifiedhuman.SparkingValkyrieProjectile;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SuitAbilityFour
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"suit_ability_four", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user shoots arrows of poison at their enemies.", null), ImmutablePair.of((Object)"The user fires small sparkling projectiles at their enemies.", null), ImmutablePair.of((Object)"The user dashes forward, and damages all those within their path.", null), ImmutablePair.of((Object)"The user gains height and rapidly accelerates down at their enemy, stunning them.", null), ImmutablePair.of((Object)"The user grabs their target and spins them around, dealing massive damage and disorientating them.", null)});
    private static final TranslationTextComponent SUIT_ABILITY_FOUR = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.suit_ability_four", "Suit Ability Four"));
    private static final TranslationTextComponent PINK_HORNET_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.pink_hornet", "Pink Hornet"));
    private static final TranslationTextComponent SPARKLING_VALKYRIE_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.sparkling_valkyrie", "Sparkling Valkyrie"));
    private static final TranslationTextComponent SHOCKING_DASH_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.shocking_dash", "Shocking Dash"));
    private static final TranslationTextComponent SOBA_KICK_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.soba_kick", "Soba Kick"));
    private static final TranslationTextComponent WINCH_DANTON_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.winch_danton", "Winch Danton"));
    private static final ResourceLocation SUIT_ABILITY_ICON = new ResourceLocation("cartaddon", "textures/abilities/suit_ability_four.png");
    private static final ResourceLocation PINK_HORNET_ICON = new ResourceLocation("cartaddon", "textures/abilities/pink_hornet.png");
    private static final ResourceLocation SPARKLING_VALKYRIE_ICON = new ResourceLocation("cartaddon", "textures/abilities/sparkling_valkyrie.png");
    private static final ResourceLocation SHOCKING_DASH_ICON = new ResourceLocation("cartaddon", "textures/abilities/shocking_dash.png");
    private static final ResourceLocation SOBA_KICK_ICON = new ResourceLocation("cartaddon", "textures/abilities/soba_kick.png");
    private static final ResourceLocation WINCH_DANTON_ICON = new ResourceLocation("cartaddon", "textures/abilities/winch_danton.png");
    private int PH_COOLDOWN = 200;
    private int SV_COOLDOWN = 400;
    private int SD_COOLDOWN = 200;
    private int SD_DAMAGE = 45;
    private int SK_CHARGE_TIME = 10;
    private int SK_COOLDOWN = 800;
    private int SK_DAMAGE = 75;
    private int WD_HOLDTIME = 80;
    private int WD_COOLDOWN = 400;
    private int WD_DAMAGE = 60;
    public static final AbilityCore<SuitAbilityFour> INSTANCE = new AbilityCore.Builder("Suit Ability Four", AbilityCategory.RACIAL, SuitAbilityFour::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> PINK_HORNET_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.LIGHT_PURPLE)), (e, a) -> DESCRIPTION[0], ChargeComponent.getTooltip((float)20.0f), CooldownComponent.getTooltip((float)200.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> SPARKLING_VALKYRIE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), (e, a) -> DESCRIPTION[1], DealDamageComponent.getTooltip((float)4.0f), CooldownComponent.getTooltip((float)400.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> SHOCKING_DASH_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE)), (e, a) -> DESCRIPTION[2], DealDamageComponent.getTooltip((float)45.0f), CooldownComponent.getTooltip((float)200.0f), RangeComponent.getTooltip((float)2.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> SOBA_KICK_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)), (e, a) -> DESCRIPTION[3], DealDamageComponent.getTooltip((float)85.0f), ChargeComponent.getTooltip((float)10.0f), CooldownComponent.getTooltip((float)800.0f), RangeComponent.getTooltip((float)5.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> WINCH_DANTON_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[4], DealDamageComponent.getTooltip((float)65.0f), ChargeComponent.getTooltip((float)40.0f), CooldownComponent.getTooltip((float)400.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceElement(SourceElement.POISON).setUnlockCheck(SuitAbilityFour::canUnlock).build();
    private final AltModeComponent<Mode> altModeComponent;
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::onChargeTick).addEndEvent(this::endChargeEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final GrabEntityComponent grabComponent = new GrabEntityComponent((IAbility)this, true, false, true, 2.0f).addPullStartEvent(this::onPullStart).addPullEndEvent(this::onPullEnd);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addOnHitEvent(this::onHitEvent);
    private final PoolComponent poolComponent;
    private final Interval clearHitsInterval;
    private final RepeaterComponent repeaterComponent = new RepeaterComponent((IAbility)this).addTriggerEvent(this::repeaterTriggerEvent).addStopEvent(this::repeaterStopEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private int lastMode = -1;
    private float distance = 2.0f;

    public SuitAbilityFour(AbilityCore<SuitAbilityThree> core) {
        super(core);
        this.poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);
        this.clearHitsInterval = new Interval(20);
        this.isNew = true;
        this.altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.NONE, true).addChangeModeEvent(this::onAltModeChange);
        this.addComponents(new AbilityComponent[]{this.projectileComponent, this.repeaterComponent, this.hitTrackerComponent, this.grabComponent, this.hitTriggerComponent, this.poolComponent, this.animationComponent, this.dealDamageComponent, this.rangeComponent, this.altModeComponent, this.continuousComponent, this.chargeComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.POISON_PINK) {
            this.chargeComponent.startCharging(entity, 20.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
            if (this.continuousComponent.isContinuous()) {
                this.repeaterComponent.stop(entity);
            } else {
                this.continuousComponent.triggerContinuity(entity);
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.ELECTRIC_SHOCK_BLUE) {
            if (!this.continuousComponent.isContinuous()) {
                this.continuousComponent.startContinuity(entity, 10.0f);
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.STEALTH_BLACK) {
            if (!this.chargeComponent.isCharging()) {
                this.chargeComponent.startCharging(entity, 10.0f);
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN) {
            if (this.chargeComponent.isCharging()) {
                this.chargeComponent.stopCharging(entity);
            } else {
                this.clearHitsInterval.restartIntervalToZero();
                if (!this.continuousComponent.isContinuous() || this.grabComponent.getState() != GrabEntityComponent.GrabState.IDLE && this.grabComponent.getState() != GrabEntityComponent.GrabState.PULLING) {
                    if (this.grabComponent.getState() == GrabEntityComponent.GrabState.IDLE && this.grabComponent.grabNearest(entity, 4.5f, 2.0f, false)) {
                        this.grabComponent.triggerPulling(entity);
                    } else {
                        this.continuousComponent.startContinuity(entity, 40.0f);
                    }
                } else {
                    this.grabComponent.release(entity);
                    this.continuousComponent.stopContinuity(entity);
                }
            }
        }
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN) {
            this.animationComponent.start(entity, ModAnimations.POINT_ARMS);
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!ModifiedHumanHelper.hasSuitActive(entity)) {
            if (this.lastMode == 0) {
                this.cooldownComponent.startCooldown(entity, 200.0f);
            }
            if (this.lastMode == 3) {
                this.cooldownComponent.startCooldown(entity, 800.0f);
            }
            if (this.lastMode == 4) {
                if (this.grabComponent.hasGrabbedEntity()) {
                    this.grabComponent.throwTarget(entity, 2.0, 0.5);
                    this.continuousComponent.startContinuity(entity, 40.0f);
                } else {
                    this.cooldownComponent.startCooldown(entity, 400.0f);
                }
            }
        }
        if (this.altModeComponent.getCurrentMode() == Mode.POISON_PINK) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.PINK_HORNET.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        } else if (this.altModeComponent.getCurrentMode() == Mode.STEALTH_BLACK) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 0));
        } else if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN && !entity.field_70170_p.field_72995_K) {
            if (!super.canUse(entity).isFail() && this.grabComponent.canContinueGrab(entity)) {
                LivingEntity grabbedTarget = this.grabComponent.getGrabbedEntity();
                entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1));
                grabbedTarget.func_195064_c(new EffectInstance((Effect)ModEffects.GRABBED.get(), 2, 3));
                Vector3d direction = grabbedTarget.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b();
                ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)grabbedTarget.func_226277_ct_(), (double)grabbedTarget.func_226278_cu_(), (double)grabbedTarget.func_226281_cx_(), (float)1.0f);
                explosion.setStaticDamage(0.0f);
                explosion.setDamageEntities(false);
                explosion.setExplosionSound(false);
                explosion.setDamageOwner(false);
                explosion.setDestroyBlocks(true);
                if (this.chargeComponent.getChargeTime() > 10.0f) {
                    explosion.doExplosion();
                }
                float targetYaw = (float)Math.toDegrees(Math.atan2(direction.field_72449_c, direction.field_72450_a)) - 90.0f;
                float adjustedYaw = (targetYaw + 10.0f) % 360.0f;
                entity.field_70177_z = entity.field_70126_B = adjustedYaw % 360.0f;
                entity.field_70127_C = 0.0f;
                entity.field_70125_A = 0.0f;
                if (entity instanceof PlayerEntity) {
                    EnumSet<SPlayerPositionLookPacket.Flags> flags = EnumSet.of(SPlayerPositionLookPacket.Flags.X, SPlayerPositionLookPacket.Flags.Y, SPlayerPositionLookPacket.Flags.Z);
                    ((ServerPlayerEntity)entity).field_71135_a.func_175089_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A, flags);
                }
                if (this.chargeComponent.getChargeTime() % 5.0f == 0.0f) {
                    this.distance += 1.0f;
                }
                Vector3d lookVec = entity.func_70040_Z().func_72432_b();
                Vector3d pos = new Vector3d(lookVec.field_72450_a * (double)this.distance, (double)(entity.func_70047_e() + 1.0f) + lookVec.field_72448_b * (double)this.distance, lookVec.field_72449_c * (double)this.distance);
                AbilityHelper.setDeltaMovement((Entity)grabbedTarget, (Vector3d)entity.func_213303_ch().func_178787_e(pos).func_178788_d(grabbedTarget.func_213303_ch()));
                List targets = WyHelper.getNearbyLiving((Vector3d)entity.func_213303_ch(), (IWorld)entity.field_70170_p, (double)grabbedTarget.func_213311_cf(), (double)grabbedTarget.func_213302_cg(), (double)grabbedTarget.func_213311_cf(), (Predicate)ModEntityPredicates.getEnemyFactions((LivingEntity)entity));
                targets.remove(grabbedTarget);
                if (!HakiHelper.hasHardeningActive((LivingEntity)entity)) {
                    targets.removeIf(targetx -> DevilFruitCapability.get((LivingEntity)entity).isLogia());
                }
                Vector3d dir = lookVec.func_186678_a(0.5);
                for (LivingEntity target : targets) {
                    if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 10.0f)) continue;
                    AbilityHelper.setDeltaMovement((Entity)target, (double)dir.field_72450_a, (double)0.5, (double)dir.field_72449_c);
                }
                if (this.clearHitsInterval.canTick()) {
                    this.hitTrackerComponent.clearHits();
                }
            } else {
                this.chargeComponent.stopCharging(entity);
            }
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.POISON_PINK) {
            this.continuousComponent.triggerContinuity(entity);
        } else if (this.altModeComponent.getCurrentMode() == Mode.STEALTH_BLACK) {
            this.continuousComponent.startContinuity(entity);
        } else if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN) {
            this.distance = 2.0f;
            if (!entity.field_70170_p.field_72995_K) {
                if (this.grabComponent.hasGrabbedEntity()) {
                    LivingEntity grabbedTarget = this.grabComponent.getGrabbedEntity();
                    if (this.dealDamageComponent.hurtTarget(entity, grabbedTarget, 65.0f)) {
                        grabbedTarget.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60, 0));
                        grabbedTarget.func_195064_c(new EffectInstance(Effects.field_76440_q, 60, 0));
                    }
                    this.grabComponent.throwTarget(entity, 2.0, 0.5);
                    this.continuousComponent.startContinuity(entity, 40.0f);
                } else {
                    this.cooldownComponent.startCooldown(entity, 400.0f);
                }
                this.animationComponent.stop(entity);
            }
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.POISON_PINK) {
            this.repeaterComponent.start(entity, 12, 2);
        } else if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
            if (!entity.field_70170_p.field_72995_K) {
                this.repeaterComponent.start(entity, 30, 3);
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.ELECTRIC_SHOCK_BLUE) {
            Vector3d speed = entity.func_70040_Z().func_216372_d(4.5, 0.0, 4.5);
            AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)0.3, (double)speed.field_72449_c);
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.LIGHTNING_TELEPORT.get(), SoundCategory.PLAYERS, 2.0f, 2.0f);
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 2.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.STEALTH_BLACK) {
            Vector3d speed = entity.func_70040_Z().func_216372_d(1.0, 1.0, 1.0);
            AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)5.0, (double)speed.field_72449_c);
        }
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!ModifiedHumanHelper.hasSuitActive(entity)) {
            if (this.lastMode == 3) {
                this.continuousComponent.stopContinuity(entity);
            }
            if (this.lastMode == 4) {
                this.continuousComponent.stopContinuity(entity);
            }
        }
        if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1, false, false));
            AbilityHelper.slowEntityFall((LivingEntity)entity);
        } else if (this.altModeComponent.getCurrentMode() == Mode.ELECTRIC_SHOCK_BLUE) {
            if (entity.func_70089_S()) {
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.SHOCKING_DASH.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
                List targets = this.rangeComponent.getTargetsInArea(entity, 2.0f);
                DamageSource source = ModDamageSource.field_180137_b;
                for (LivingEntity target : targets) {
                    this.dealDamageComponent.hurtTarget(entity, target, 45.0f, source);
                }
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.STEALTH_BLACK) {
            boolean activeHover;
            IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
            HoverBootsAbility hoverBootsAbility = (HoverBootsAbility)props.getEquippedAbility(HoverBootsAbility.INSTANCE);
            boolean bl = activeHover = hoverBootsAbility != null && hoverBootsAbility.isContinuous();
            if (activeHover) {
                hoverBootsAbility.stop(entity, true);
            }
            List targets = this.rangeComponent.getTargetsInArea(entity, 5.0f);
            targets.remove(entity);
            if (this.continuousComponent.getContinueTime() < 30.0f) {
                if (this.continuousComponent.getContinueTime() % 5.0f == 0.0f) {
                    entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GEPPO_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.75f);
                    WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.GEPPO.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
                }
            } else if (this.continuousComponent.getContinueTime() > 30.0f) {
                Vector3d speed = entity.func_70040_Z().func_216372_d(6.75, 1.0, 6.75);
                AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)-5.0, (double)speed.field_72449_c);
                for (LivingEntity target : targets) {
                    this.dealDamageComponent.hurtTarget(entity, target, 85.0f);
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 20, 0, false, false));
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60, 0, false, false));
                }
                ExplosionAbility explosion = AbilityHelper.newExplosion(null, (World)entity.field_70170_p, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (float)4.0f);
                explosion.setExplosionSound(true);
                explosion.setDamageEntities(false);
                explosion.setDamageOwner(false);
                explosion.setDestroyBlocks(true);
                explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(3));
                explosion.doExplosion();
            }
            if (entity.func_233570_aj_()) {
                this.continuousComponent.stopContinuity(entity);
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN && this.grabComponent.getState() != GrabEntityComponent.GrabState.IDLE) {
            if (!this.grabComponent.canContinueGrab(entity)) {
                this.continuousComponent.stopContinuity(entity);
            } else if (this.grabComponent.getState() == GrabEntityComponent.GrabState.THROWN) {
                LivingEntity grabbedTarget = this.grabComponent.getGrabbedEntity();
                if (grabbedTarget.func_233570_aj_()) {
                    this.grabComponent.release(entity);
                    this.continuousComponent.stopContinuity(entity);
                } else {
                    List targets = WyHelper.getNearbyLiving((Vector3d)grabbedTarget.func_213303_ch(), (IWorld)entity.field_70170_p, (double)grabbedTarget.func_213311_cf(), (double)grabbedTarget.func_213302_cg(), (double)grabbedTarget.func_213311_cf(), (Predicate)null);
                    targets.remove(grabbedTarget);
                    Vector3d dir = entity.func_70040_Z().func_72432_b().func_186678_a(2.0);
                    for (LivingEntity target : targets) {
                        if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 10.0f)) continue;
                        AbilityHelper.setDeltaMovement((Entity)target, (double)dir.field_72450_a, (double)0.5, (double)dir.field_72449_c);
                    }
                    if (this.clearHitsInterval.canTick()) {
                        this.hitTrackerComponent.clearHits();
                    }
                }
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.ELECTRIC_SHOCK_BLUE || this.lastMode == 2) {
            this.cooldownComponent.startCooldown(entity, 200.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.STEALTH_BLACK || this.lastMode == 3) {
            this.cooldownComponent.startCooldown(entity, 800.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN || this.lastMode == 4) {
            this.distance = 2.0f;
            if (!entity.field_70170_p.field_72995_K) {
                if (this.grabComponent.getState() != GrabEntityComponent.GrabState.GRABBED) {
                    this.grabComponent.release(entity);
                }
                if (!this.grabComponent.canContinueGrab(entity)) {
                    this.cooldownComponent.startCooldown(entity, 400.0f);
                }
            }
        }
    }

    private void repeaterTriggerEvent(LivingEntity entity, IAbility ability) {
        if (super.canUse(entity).isFail()) {
            this.repeaterComponent.stop(entity);
        }
        if (this.altModeComponent.getCurrentMode() == Mode.POISON_PINK) {
            this.projectileComponent.shoot(entity, 3.5f, 4.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
            this.projectileComponent.shoot(entity, 7.0f, 15.0f);
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PIKA_SFX.get(), SoundCategory.PLAYERS, 2.0f, 2.0f);
        } else {
            this.repeaterComponent.stop(entity);
        }
    }

    private void repeaterStopEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        if (this.altModeComponent.getCurrentMode() == Mode.POISON_PINK || this.lastMode == 0) {
            this.cooldownComponent.startCooldown(entity, 200.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED || this.lastMode == 1) {
            this.cooldownComponent.startCooldown(entity, 400.0f);
        }
    }

    private AbilityProjectileEntity createProjectile(LivingEntity entity) {
        AbilityProjectileEntity proj = null;
        if (this.altModeComponent.getCurrentMode() == Mode.POISON_PINK) {
            proj = new PinkHornetProjectile(entity.field_70170_p, entity, this);
        } else if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
            proj = new SparkingValkyrieProjectile(entity.field_70170_p, entity, this);
        }
        return proj;
    }

    private boolean onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN) {
            if (this.continuousComponent.isContinuous() && !this.grabComponent.hasGrabbedEntity()) {
                if (this.grabComponent.grabManually(entity, target)) {
                    this.grabComponent.startPulling(entity);
                }
                target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 1));
                return false;
            }
            return true;
        }
        return true;
    }

    public void onPullStart(LivingEntity entity, IAbility ability) {
        this.continuousComponent.setThresholdTime(entity, 200.0f);
    }

    public void onPullEnd(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        if (this.grabComponent.canContinueGrab(entity)) {
            this.chargeComponent.startCharging(entity, 40.0f);
        }
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.NONE) {
            super.setDisplayIcon(SUIT_ABILITY_ICON);
            super.setDisplayName((ITextComponent)SUIT_ABILITY_FOUR);
        } else if (mode == Mode.POISON_PINK) {
            super.setDisplayIcon(PINK_HORNET_ICON);
            super.setDisplayName((ITextComponent)PINK_HORNET_NAME);
            this.lastMode = 0;
        } else if (mode == Mode.SPARKLING_RED) {
            super.setDisplayIcon(SPARKLING_VALKYRIE_ICON);
            super.setDisplayName((ITextComponent)SPARKLING_VALKYRIE_NAME);
            this.lastMode = 1;
        } else if (mode == Mode.ELECTRIC_SHOCK_BLUE) {
            super.setDisplayIcon(SHOCKING_DASH_ICON);
            super.setDisplayName((ITextComponent)SHOCKING_DASH_NAME);
            this.lastMode = 2;
        } else if (mode == Mode.STEALTH_BLACK) {
            super.setDisplayIcon(SOBA_KICK_ICON);
            super.setDisplayName((ITextComponent)SOBA_KICK_NAME);
            this.lastMode = 3;
        } else if (mode == Mode.WINCH_GREEN) {
            super.setDisplayIcon(WINCH_DANTON_ICON);
            super.setDisplayName((ITextComponent)WINCH_DANTON_NAME);
            this.lastMode = 4;
        }
    }

    public void switchNone(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.NONE);
    }

    public void switchPoisonPink(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.POISON_PINK);
    }

    public void switchSparklingRed(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.SPARKLING_RED);
    }

    public void switchShockBlue(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.ELECTRIC_SHOCK_BLUE);
    }

    public void switchStealthBlack(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.STEALTH_BLACK);
    }

    public void switchWinchGreen(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.WINCH_GREEN);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getDoriki() >= 8000.0;
    }

    public static enum Mode {
        NONE,
        POISON_PINK,
        SPARKLING_RED,
        ELECTRIC_SHOCK_BLUE,
        STEALTH_BLACK,
        WINCH_GREEN;

    }
}

