/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman.old;

import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class ModHumanSuitChooserAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"modified_human_suit_chooser", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user shoots a small bundle of strings, acting like a bullet", null)});
    private static final float COOLDOWN = 30.0f;
    public static final AbilityCore<ModHumanSuitChooserAbility> INSTANCE = new AbilityCore.Builder("Modified Human Race Chooser", AbilityCategory.RACIAL, ModHumanSuitChooserAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)30.0f)}).setUnlockCheck(ModHumanSuitChooserAbility::canUnlock).build();
    private final AltModeComponent altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.POISON_PINK).addChangeModeEvent(this::onAltModeChange);

    public ModHumanSuitChooserAbility(AbilityCore<ModHumanSuitChooserAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.altModeComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(PlayerEntity entity, IAbility ability) {
        IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)entity);
        if (this.altModeComponent.getCurrentMode() == Mode.POISON_PINK) {
            entityStatsProps.setSubRace("poison_pink");
            entity.func_145747_a((ITextComponent)new StringTextComponent("You chose Poison Pink!"), entity.func_110124_au());
        }
        if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
            entityStatsProps.setSubRace("sparkling_red");
            entity.func_145747_a((ITextComponent)new StringTextComponent("You chose Sparkling Red!"), entity.func_110124_au());
        }
        if (this.altModeComponent.getCurrentMode() == Mode.ELECTRIC_SHOCK_BLUE) {
            entityStatsProps.setSubRace("electric_shock_blue");
            entity.func_145747_a((ITextComponent)new StringTextComponent("You chose Electric Shock Blue!"), entity.func_110124_au());
        }
        if (this.altModeComponent.getCurrentMode() == Mode.STEALTH_BLACK) {
            entityStatsProps.setSubRace("stealth_black");
            entity.func_145747_a((ITextComponent)new StringTextComponent("You chose Stealth Black!"), entity.func_110124_au());
        }
        if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN) {
            entityStatsProps.setSubRace("winch_green");
            entity.func_145747_a((ITextComponent)new StringTextComponent("You chose Winch Green!"), entity.func_110124_au());
        }
        if (entity instanceof ServerPlayerEntity) {
            WyNetwork.sendTo((Object)new SSyncEntityStatsPacket(entity.func_145782_y(), entityStatsProps), (PlayerEntity)entity);
        }
        this.cooldownComponent.startCooldown((LivingEntity)entity, 40.0f);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getSubRace().equals("no_suit");
    }

    public static enum Mode {
        POISON_PINK,
        SPARKLING_RED,
        ELECTRIC_SHOCK_BLUE,
        STEALTH_BLACK,
        WINCH_GREEN;

    }
}

