/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman.electicshockblue;

import java.util.List;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ElectricmotiveNeedleAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"electricmotive_needle", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user rapidly moves behind their target, and inflicts a stun kick.", null)});
    private static final int EM_CON_TIME = 10;
    private static final int EM_COOLDOWN = 240;
    private static final int EM_RANGE = 15;
    private static final int EM_DAMAGE = 40;
    public static final AbilityCore<ElectricmotiveNeedleAbility> INSTANCE = new AbilityCore.Builder("Electricmotive Needle", AbilityCategory.RACIAL, ElectricmotiveNeedleAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)40.0f), ContinuousComponent.getTooltip((float)10.0f), CooldownComponent.getTooltip((float)240.0f), RangeComponent.getTooltip((float)15.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).setSourceType(new SourceType[]{SourceType.FIST}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceElement(SourceElement.LIGHTNING).setUnlockCheck(ElectricmotiveNeedleAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addTickEvent(this::onContinuityTick).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);
    private LivingEntity target;
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.ELECTRIC_SHOCK_BLUE.get(), new MorphInfo[0]);

    public ElectricmotiveNeedleAbility(AbilityCore<ElectricmotiveNeedleAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.requireMorphComponent, this.poolComponent, this.rangeComponent, this.continuousComponent, this.dealDamageComponent, this.animationComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            List targets = this.rangeComponent.getTargetsInLine(entity, 15.0f, 3.0f);
            if (targets.size() > 0) {
                this.target = (LivingEntity)targets.get(0);
            }
            if (this.target != null) {
                Vector3d targetLook = VectorHelper.calculateViewVectorFromBodyRot((float)this.target.field_70125_A, (float)this.target.field_70761_aq).func_216372_d(-2.0, 0.0, -2.0);
                Vector3d newPos = this.target.func_213303_ch().func_178787_e(targetLook);
                entity.func_195064_c(new EffectInstance((Effect)ModEffects.VANISH.get(), 10, 0, false, false));
                entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), (int)this.continuousComponent.getThresholdTime(), 0, false, false));
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.GORO_LOGIA.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)(entity.func_226278_cu_() + 0.5), (double)entity.func_226281_cx_());
                entity.func_223102_j(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
                entity.func_200602_a(EntityAnchorArgument.Type.EYES, this.target.func_213303_ch().func_72441_c(0.0, (double)this.target.func_70047_e(), 0.0));
                entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
                this.continuousComponent.startContinuity(entity, 10.0f);
            } else {
                this.cooldownComponent.startCooldown(entity, 60.0f);
            }
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && this.target != null && this.target.func_70089_S() && Math.abs(this.target.func_70032_d((Entity)entity)) < 5.0f) {
            this.animationComponent.start(entity, ModAnimations.PITCH_SPIN, 7);
            entity.func_226292_a_(Hand.MAIN_HAND, true);
            List targets = this.rangeComponent.getTargetsInArea(entity, this.target.func_233580_cy_(), 2.0f);
            for (LivingEntity target : targets) {
                this.dealDamageComponent.hurtTarget(entity, target, 40.0f);
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60, 0, false, false));
                target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0, false, false));
            }
        }
        this.target = null;
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getSubRace().equals("electric_shock_blue");
    }
}

