/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman.electicshockblue;

import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.HoverBootsAbility;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartAnimations;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.DropHitAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ElectricalSurgeAbility
extends DropHitAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"electrical_surge", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user jumps into the air, and generates damaging electricity below them. At the end of this ability, the user lands and does damage.", null)});
    public static final AbilityCore<ElectricalSurgeAbility> INSTANCE = new AbilityCore.Builder("Electrical Surge", AbilityCategory.RACIAL, ElectricalSurgeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)5.0f, (float)60.0f), CooldownComponent.getTooltip((float)800.0f), RangeComponent.getTooltip((float)11.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceElement(SourceElement.LIGHTNING).setUnlockCheck(ElectricalSurgeAbility::canUnlock).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.INIT_JUMP, new AbilityPool2[]{ModAbilityPools.GRAB_ABILITY});
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.ELECTRIC_SHOCK_BLUE.get(), new MorphInfo[0]);
    private static final int COOLDOWN = 800;
    private static final float RANGE = 7.0f;
    private static final float DMG = 50.0f;
    private Interval dmgInterval = new Interval(15);

    public ElectricalSurgeAbility(AbilityCore<ElectricalSurgeAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.requireMorphComponent, this.poolComponent, this.poolComponent, this.animationComponent, this.dealDamageComponent, this.rangeComponent});
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(100, this::endContinuityEvent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
    }

    public void onLanding(LivingEntity entity) {
        this.animationComponent.stop(entity);
        List targets = this.rangeComponent.getTargetsInArea(entity, 11.0f);
        targets.remove(entity);
        AbilityDamageSource source = (AbilityDamageSource)ModDamageSource.causeAbilityDamage((LivingEntity)entity, (AbilityCore)this.getCore()).setFistDamage();
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 50.0f, (DamageSource)source)) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 20));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 20));
            AbilityHelper.disableAbilities((LivingEntity)target, (int)100, abl -> abl.hasComponent(ModAbilityKeys.POOL) && ((PoolComponent)abl.getComponent(ModAbilityKeys.POOL).get()).containsPool(ModAbilityPools.TEKKAI_LIKE));
        }
        if (!entity.field_70170_p.field_72995_K) {
            if (targets.size() > 0) {
                ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
            }
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10));
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, CartAnimations.ELECTRICAL_SURGE);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 30, 0));
        Vector3d speed = WyHelper.propulsion((LivingEntity)entity, (double)1.0, (double)1.0);
        AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)2.5, (double)speed.field_72449_c);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        boolean activeHover;
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        HoverBootsAbility hoverBootsAbility = (HoverBootsAbility)props.getEquippedAbility(HoverBootsAbility.INSTANCE);
        boolean bl = activeHover = hoverBootsAbility != null && hoverBootsAbility.isContinuous();
        if (activeHover) {
            hoverBootsAbility.stop(entity, true);
        }
        List list = WyHelper.getNearbyLiving((Vector3d)entity.func_213303_ch(), (IWorld)entity.field_70170_p, (double)11.0, (double)200.0, (double)11.0, (Predicate)ModEntityPredicates.getEnemyFactions((LivingEntity)entity));
        for (LivingEntity target : list) {
            if (!(target.func_226278_cu_() > entity.func_226278_cu_())) continue;
            list.remove(target);
        }
        if (this.continuousComponent.getContinueTime() % 5.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.ELECTRICAL_SURGE.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)(entity.func_226278_cu_() - DevilFruitHelper.getDifferenceToFloor((Entity)entity) + 1.0), (double)entity.func_226281_cx_());
        }
        if (this.continuousComponent.getContinueTime() < 30.0f) {
            if (DevilFruitHelper.getDifferenceToFloor((Entity)entity) > 15.0) {
                AbilityHelper.slowEntityFall((LivingEntity)entity);
            }
            if (this.dmgInterval.canTick()) {
                for (LivingEntity target : list) {
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0, false, false));
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 10, 0, false, false));
                    this.dealDamageComponent.hurtTarget(entity, target, 5.0f);
                }
            }
        }
        if (this.continuousComponent.getContinueTime() >= 30.0f) {
            Vector3d speed = entity.func_70040_Z().func_216372_d(1.0, 1.0, 1.0);
            AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)-8.0, (double)speed.field_72449_c);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.hitTrackerComponent.clearHits();
        this.cooldownComponent.startCooldown(entity, 800.0f);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getSubRace().equals("electric_shock_blue");
    }
}

