/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman.electicshockblue;

import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.MrMagicalCart.cartaddon.particles.effects.modifiedhuman.ElectricFieldParticleEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ElectricFieldAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"electric_field", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user generates electricity around themselves, stunning all those nearby.", null)});
    private static final int EF_CHARGE_TIME = 40;
    private static final int EF_MIN_COOLDOWN = 300;
    private static final int EF_MAX_COOLDOWN = 400;
    private static final int EF_RANGE = 2;
    public static final AbilityCore<ElectricFieldAbility> INSTANCE;
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    protected final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);
    private static final ElectricFieldParticleEffect.Details DETAILS;
    private final Interval particleInterval = new Interval(2);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.ELECTRIC_SHOCK_BLUE.get(), new MorphInfo[0]);

    public ElectricFieldAbility(AbilityCore<ElectricFieldAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.requireMorphComponent, this.poolComponent, this.chargeComponent, this.animationComponent, this.rangeComponent, this.hitTrackerComponent, this.dealDamageComponent});
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            this.particleInterval.restartIntervalToZero();
            this.chargeComponent.startCharging(entity, 40.0f);
        } else {
            this.chargeComponent.stopCharging(entity);
        }
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.RYU_NO_IBUKI);
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1));
            if (this.particleInterval.canTick()) {
                DETAILS.setRange(2);
                DETAILS.setSize(2.0f);
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.ELECTRIC_FIELD.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (ParticleEffect.Details)DETAILS);
            }
            float range = this.rangeComponent.getBonusManager().applyBonus(2.0f);
            List targets = WyHelper.getNearbyEntities((Vector3d)entity.func_213303_ch(), (IWorld)entity.field_70170_p, (double)range, (Predicate)null, (Class[])new Class[]{Entity.class});
            for (Entity target : targets) {
                if (target instanceof LivingEntity && target != entity) {
                    ((LivingEntity)target).func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 1));
                    ((LivingEntity)target).func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0));
                    ((LivingEntity)target).func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 20, 0));
                    ((LivingEntity)target).func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 20, 0));
                    continue;
                }
                if (!(target instanceof AbilityProjectileEntity)) continue;
                AbilityProjectileEntity abilityProj = (AbilityProjectileEntity)target;
                if (abilityProj.getDamageSource().isPhysical()) {
                    LivingEntity thrower = abilityProj.getThrower();
                    if (thrower == null || thrower == entity) continue;
                    target.func_70106_y();
                    continue;
                }
                target.func_70106_y();
            }
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.animationComponent.stop(entity);
            entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187752_dd, SoundCategory.WEATHER, 2.0f, 0.5f + entity.func_70681_au().nextFloat() * 0.2f);
            float cooldown = Math.max(300.0f, 400.0f * this.chargeComponent.getChargePercentage());
            this.cooldownComponent.startCooldown(entity, cooldown);
        }
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getSubRace().equals("electric_shock_blue");
    }

    static {
        DETAILS = new ElectricFieldParticleEffect.Details();
        INSTANCE = new AbilityCore.Builder("Electric Field", AbilityCategory.RACIAL, ElectricFieldAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)300.0f, (float)400.0f)}).setSourceType(new SourceType[]{SourceType.INDIRECT}).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.LIGHTNING).setUnlockCheck(ElectricFieldAbility::canUnlock).build();
    }
}

