/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman;

import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class RaidSuitAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"raid_suit", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user equips the specified Raid Suit. (Change suits by using the specified key-bind for CHANGE ABILITY MODE in controls. Works similar to swapping alt modes)", null)});
    private static final ResourceLocation POSION_PINK_ICON = new ResourceLocation("cartaddon", "textures/abilities/poison_pink.png");
    private static final ResourceLocation SPARKLING_RED_ICON = new ResourceLocation("cartaddon", "textures/abilities/sparkling_red.png");
    private static final ResourceLocation ELECTRIC_SHOCK_BLUE_ICON = new ResourceLocation("cartaddon", "textures/abilities/electric_shock_blue.png");
    private static final ResourceLocation STEALTH_BLACK_ICON = new ResourceLocation("cartaddon", "textures/abilities/stealth_black.png");
    private static final ResourceLocation WINCH_GREEN_ICON = new ResourceLocation("cartaddon", "textures/abilities/winch_green.png");
    public static final AbilityCore<RaidSuitAbility> INSTANCE = new AbilityCore.Builder("Raid Suit", AbilityCategory.RACIAL, RaidSuitAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)200.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{ChangeStatsComponent.getTooltip()}).setUnlockCheck(RaidSuitAbility::canUnlock).build();
    private static final AbilityAttributeModifier SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_MOVEMENT_SPEED_UUID, INSTANCE, "Raid Suit Speed Modifier", 0.05, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER;
    private static final AbilityAttributeModifier ATTACK_SPEED_MODIFIER;
    private static final AbilityAttributeModifier JUMP_BOOST_MODIFIER;
    private static final AbilityAttributeModifier ARMOR_MODIFIER;
    private static final AbilityAttributeModifier ARMOR_TOUGHNESS_MODIFIER;
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER;
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::onContinuityTick).addEndEvent(this::endContinuityEvent);
    private final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.POISON_PINK, true).addChangeModeEvent(this::onAltModeChange);

    public RaidSuitAbility(AbilityCore<RaidSuitAbility> core) {
        super(core);
        this.isNew = true;
        this.statsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)SPEED_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233823_f_, (AttributeModifier)STRENGTH_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.JUMP_HEIGHT, (AttributeModifier)JUMP_BOOST_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)ARMOR_TOUGHNESS_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER);
        this.addComponents(new AbilityComponent[]{this.damageTakenComponent, this.altModeComponent, this.continuousComponent, this.statsComponent, this.morphComponent});
        super.addCanUseCheck(AbilityLimits::fruitless);
        this.addUseEvent(this::useEvent);
        this.addEquipEvent(this::onEquip);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        String subrace = props.getSubRace();
        if (subrace.equals("no_suit")) {
            return;
        }
        if (subrace.equals("poison_pink")) {
            this.altModeComponent.setMode(entity, (Enum)Mode.POISON_PINK);
        }
        if (subrace.equals("sparkling_red")) {
            this.altModeComponent.setMode(entity, (Enum)Mode.SPARKLING_RED);
        }
        if (subrace.equals("electric_shock_blue")) {
            this.altModeComponent.setMode(entity, (Enum)Mode.ELECTRIC_SHOCK_BLUE);
        }
        if (subrace.equals("stealth_black")) {
            this.altModeComponent.setMode(entity, (Enum)Mode.STEALTH_BLACK);
        }
        if (subrace.equals("winch_green")) {
            this.altModeComponent.setMode(entity, (Enum)Mode.WINCH_GREEN);
        }
        this.continuousComponent.triggerContinuity(entity);
    }

    private void onEquip(LivingEntity entity, Ability ability) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        if (props.getSubRace().equals("poison_pink")) {
            this.altModeComponent.setMode(entity, (Enum)Mode.POISON_PINK);
        }
        if (props.getSubRace().equals("sparkling_red")) {
            this.altModeComponent.setMode(entity, (Enum)Mode.SPARKLING_RED);
        }
        if (props.getSubRace().equals("electric_shock_blue")) {
            this.altModeComponent.setMode(entity, (Enum)Mode.ELECTRIC_SHOCK_BLUE);
        }
        if (props.getSubRace().equals("stealth_black")) {
            this.altModeComponent.setMode(entity, (Enum)Mode.STEALTH_BLACK);
        }
        if (props.getSubRace().equals("winch_green")) {
            this.altModeComponent.setMode(entity, (Enum)Mode.WINCH_GREEN);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.POISON_PINK) {
            this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.POISON_PINK.get());
        } else if (this.altModeComponent.getCurrentMode() == Mode.SPARKLING_RED) {
            this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.SPARKLING_RED.get());
        } else if (this.altModeComponent.getCurrentMode() == Mode.ELECTRIC_SHOCK_BLUE) {
            this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.ELECTRIC_SHOCK_BLUE.get());
        } else if (this.altModeComponent.getCurrentMode() == Mode.STEALTH_BLACK) {
            this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.STEALTH_BLACK.get());
        } else if (this.altModeComponent.getCurrentMode() == Mode.WINCH_GREEN) {
            this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.WINCH_GREEN.get());
        }
        this.statsComponent.applyModifiers(entity);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (AbilityLimits.ateFruit(entity, (IAbility)this)) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.stopMorph(entity);
        this.statsComponent.removeModifiers(entity);
        this.cooldownComponent.startCooldown(entity, 60.0f);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.POISON_PINK) {
            super.setDisplayIcon(POSION_PINK_ICON);
        } else if (mode == Mode.SPARKLING_RED) {
            super.setDisplayIcon(SPARKLING_RED_ICON);
        } else if (mode == Mode.ELECTRIC_SHOCK_BLUE) {
            super.setDisplayIcon(ELECTRIC_SHOCK_BLUE_ICON);
        } else if (mode == Mode.STEALTH_BLACK) {
            super.setDisplayIcon(STEALTH_BLACK_ICON);
        } else if (mode == Mode.WINCH_GREEN) {
            super.setDisplayIcon(WINCH_GREEN_ICON);
        }
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (this.continuousComponent.isContinuous() && damageSource == DamageSource.field_76379_h) {
            return 0.0f;
        }
        return damage;
    }

    public void switchSuit(LivingEntity entity, String subrace) {
        if (subrace.equals("poison_pink")) {
            this.altModeComponent.setMode(entity, (Enum)Mode.POISON_PINK);
        } else if (subrace.equals("sparkling_red")) {
            this.altModeComponent.setMode(entity, (Enum)Mode.SPARKLING_RED);
        } else if (subrace.equals("electric_shock_blue")) {
            this.altModeComponent.setMode(entity, (Enum)Mode.ELECTRIC_SHOCK_BLUE);
        } else if (subrace.equals("stealth_black")) {
            this.altModeComponent.setMode(entity, (Enum)Mode.STEALTH_BLACK);
        } else if (subrace.equals("winch_green")) {
            this.altModeComponent.setMode(entity, (Enum)Mode.WINCH_GREEN);
        }
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        boolean subRaceCheck = props.getSubRace().equals("no_suit");
        return race && !subRaceCheck;
    }

    static {
        ARMOR_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_UUID, INSTANCE, "Raid Suit Armor Modifier", 15.0, AttributeModifier.Operation.ADDITION);
        STRENGTH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STRENGTH_UUID, INSTANCE, "Raid Suit Attack Damage Modifier", 3.0, AttributeModifier.Operation.ADDITION);
        ATTACK_SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_SPEED_UUID, INSTANCE, "Raid Suit Attack Speed Modifier", 0.5, AttributeModifier.Operation.ADDITION);
        JUMP_BOOST_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_JUMP_BOOST_UUID, INSTANCE, "Raid Suit Jump Modifier", 1.0, AttributeModifier.Operation.ADDITION);
        ARMOR_TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_TOUGHNESS_UUID, INSTANCE, "Raid Suit Armor Toughness Modifier", 3.0, AttributeModifier.Operation.ADDITION);
        TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_TOUGHNESS_UUID, INSTANCE, "Raid Suit Toughness Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    }

    public static enum Mode {
        POISON_PINK,
        SPARKLING_RED,
        ELECTRIC_SHOCK_BLUE,
        STEALTH_BLACK,
        WINCH_GREEN;

    }
}

