/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman;

import java.util.UUID;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class GeneticAwakeningAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"genetic_awakening", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user unlocks their full potential, gaining stat buffs and immunity to fall damage.", null)});
    private static final int HOLD_TIME = 600;
    private static final int MIN_COOLDOWN = 200;
    private static final int MAX_COOLDOWN = 1400;
    public static final AbilityCore<GeneticAwakeningAbility> INSTANCE = new AbilityCore.Builder("Genetic Awakening", AbilityCategory.RACIAL, GeneticAwakeningAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip((float)600.0f), CooldownComponent.getTooltip((float)200.0f, (float)1100.0f), ChangeStatsComponent.getTooltip()}).setUnlockCheck(GeneticAwakeningAbility::canUnlock).build();
    private static final AbilityAttributeModifier SWIM_SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("5d1f71f8-abc2-409b-999b-261b15a6b866"), INSTANCE, "Genetic Awakening Swim Speed Multiplier", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier MOVEMENT_MODIFIER = new AbilityAttributeModifier(UUID.fromString("57ec901d-e43b-4e11-b220-c353bc8c0de1"), INSTANCE, "Genetic Awakening Movement Modifier", 0.03, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier JUMP_MODIFIER = new AbilityAttributeModifier(UUID.fromString("1634f0e9-bae3-4c85-945c-d83f80f1ebb5"), INSTANCE, "Genetic Awakening Jump Modifier", 0.5, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ARMOR_MODIFIER = new AbilityAttributeModifier(UUID.fromString("694c9d00-b07e-4602-91cb-c47bed3b6dd3"), INSTANCE, "Genetic Awakening Armor Modifier", 10.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier KNOCKBACK_RESISTANCE_MODIFIER = new AbilityAttributeModifier(UUID.fromString("fab30977-3b6e-43b3-aabb-e488d1d109b8"), INSTANCE, "Genetic Awakening Knockback Resistance Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ARMOR_TOUGHNESS_MODIFIER = new AbilityAttributeModifier(UUID.fromString("c62da7e7-27ae-41b0-8136-5b32b42f9b3f"), INSTANCE, "Genetic Awakening Armor Toughness Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER = new AbilityAttributeModifier(UUID.fromString("f8ca1647-8c7d-41ec-ab92-c7915ab8fa51"), INSTANCE, "Genetic Awakening Toughness Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent((IAbility)this);
    protected final DamageTakenComponent damageTakenComponent;

    public GeneticAwakeningAbility(AbilityCore<GeneticAwakeningAbility> core) {
        super(core);
        this.isNew = true;
        this.damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
        this.changeStatsComponent.addAttributeModifier((Attribute)ForgeMod.SWIM_SPEED.get(), (AttributeModifier)SWIM_SPEED_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)MOVEMENT_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.JUMP_HEIGHT, (AttributeModifier)JUMP_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233820_c_, (AttributeModifier)KNOCKBACK_RESISTANCE_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)ARMOR_TOUGHNESS_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER);
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.changeStatsComponent, this.damageTakenComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (AbilityLimits.ateFruit(entity, ability)) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("Genetic Awakening cannot be used alongside a Devil Fruit!"), entity.func_110124_au());
            return;
        }
        this.continuousComponent.triggerContinuity(entity, 600.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.applyModifiers(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (AbilityLimits.ateFruit(entity, (IAbility)this)) {
            this.continuousComponent.stopContinuity(entity);
        }
        if (entity.func_208600_a((ITag)FluidTags.field_206959_a)) {
            entity.func_70050_g(300);
            entity.func_195064_c(new EffectInstance(Effects.field_76439_r, 250, 0, false, false));
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76422_e, 5, 0, false, false));
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.removeModifiers(entity);
        float cooldown = 200.0f + this.continuousComponent.getContinueTime() * 1.5f;
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (this.continuousComponent.isContinuous() && damageSource == DamageSource.field_76379_h) {
            return 0.0f;
        }
        return damage;
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getDoriki() >= 5000.0;
    }
}

