/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman;

import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.ModifiedHumanHelper;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HealComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ExoRepairAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"exo_repair", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user stands still and mends their body.", null)});
    private final HealComponent healComponent = new HealComponent((IAbility)this);
    private static final int COOLDOWN = 1200;
    public static final AbilityCore<ExoRepairAbility> INSTANCE = new AbilityCore.Builder("Exo Repair", AbilityCategory.RACIAL, ExoRepairAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, HealComponent.getTooltip((float)15.0f), CooldownComponent.getTooltip((float)1200.0f)}).setUnlockCheck(ExoRepairAbility::canUnlock).build();

    public ExoRepairAbility(AbilityCore<ExoRepairAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.healComponent});
        super.addCanUseCheck(ModifiedHumanHelper::usingGenes);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!WyHelper.isInChallengeDimension((World)entity.field_70170_p)) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 30, 2, false, false));
            this.healComponent.healTarget(entity, entity, 15.0f);
            this.cooldownComponent.startCooldown(entity, 1200.0f);
        } else {
            this.healComponent.healTarget(entity, entity, 25.0f);
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 20, 2, false, false));
            this.cooldownComponent.startCooldown(entity, 400.0f);
        }
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_187698_i, SoundCategory.PLAYERS, 2.0f, 0.6f);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        return race && props.getDoriki() >= 7500.0;
    }
}

