/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.modifiedhuman;

import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BootBoostAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"boot_boost", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user uses their special boots to move freely in the sky.", null)});
    private static final int MAX_JUMPS = 6;
    private static final float SHORT_COOLDOWN_PER_STACK = 10.0f;
    private static final float LONG_COOLDOWN_PER_STACK = 50.0f;
    public static final AbilityCore<BootBoostAbility> INSTANCE = new AbilityCore.Builder("Boot Boost", AbilityCategory.RACIAL, BootBoostAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, AbilityHelper.createShortLongCooldownStat((float)10.0f, (float)50.0f), StackComponent.getTooltip((int)6)}).setUnlockCheck(BootBoostAbility::canUnlock).build();
    private final PoolComponent poolComponent;
    private final DamageTakenComponent damageTakenComponent;
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.POISON_PINK.get(), new MorphInfo[]{(MorphInfo)CartMorphs.SPARKLING_RED.get(), (MorphInfo)CartMorphs.ELECTRIC_SHOCK_BLUE.get(), (MorphInfo)CartMorphs.STEALTH_BLACK.get(), (MorphInfo)CartMorphs.WINCH_GREEN.get()});
    private final StackComponent stackComponent;
    private boolean hasFallDamage = true;
    private boolean hadGravity = false;
    private int noGravityTime = 8;

    public BootBoostAbility(AbilityCore<BootBoostAbility> core) {
        super(core);
        this.poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GEPPO_LIKE, new AbilityPool2[0]);
        this.damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
        this.stackComponent = new StackComponent((IAbility)this, 6);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.requireMorphComponent, this.poolComponent, this.damageTakenComponent, this.stackComponent, this.poolComponent});
        this.addUseEvent(this::onUseEvent);
        this.addTickEvent(this::tickEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        int stacksUsed = 1;
        if (this.noGravityTime <= 0) {
            this.hadGravity = !entity.func_189652_ae();
        }
        Vector3d movement = entity.func_70040_Z().func_72432_b();
        if (entity.func_70090_H()) {
            movement = movement.func_186678_a(2.5);
            stacksUsed = this.stackComponent.getStacks();
        } else {
            movement = movement.func_186678_a(entity.func_233570_aj_() ? 2.0 : 1.5);
        }
        entity.func_189654_d(true);
        this.noGravityTime = 8;
        if (entity.field_70125_A < -40.0f) {
            movement = movement.func_72441_c(0.0, -(movement.field_72448_b - movement.field_72448_b / 2.0), 0.0);
        }
        AbilityHelper.setDeltaMovement((Entity)entity, (double)movement.field_72450_a, (double)movement.field_72448_b, (double)movement.field_72449_c);
        this.stackComponent.addStacks(entity, (IAbility)this, -stacksUsed);
        this.hasFallDamage = false;
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GEPPO_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.75f + this.random.nextFloat() / 2.0f);
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.GEPPO.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        if (this.stackComponent.getStacks() <= 0) {
            this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
            this.stackComponent.setStacks(entity, (IAbility)this, 6);
        } else {
            this.cooldownComponent.startCooldown(entity, 10.0f);
        }
    }

    public void tickEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && !this.hasFallDamage && this.stackComponent.getStacks() < this.stackComponent.getDefaultStacks() && entity.func_233570_aj_() && entity.field_70170_p.func_82737_E() > this.getLastUseGametime() + 10L) {
            this.resetStacks(entity);
        }
        if (!entity.field_70170_p.field_72995_K && this.noGravityTime-- <= 0 && this.hadGravity) {
            entity.func_189654_d(false);
        }
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.resetStacks(entity);
            return 0.0f;
        }
        return damage;
    }

    private void resetStacks(LivingEntity entity) {
        if (this.stackComponent.getStacks() != this.stackComponent.getDefaultStacks()) {
            this.cooldownComponent.stopCooldown(entity);
            this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
        }
        this.stackComponent.setStacks(entity, (IAbility)this, 6);
        this.hasFallDamage = true;
    }

    private float getCooldownTicks() {
        return (float)(this.stackComponent.getDefaultStacks() - this.stackComponent.getStacks()) * 50.0f;
    }

    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74757_a("hasFallDamage", this.hasFallDamage);
        nbt.func_74757_a("hadGravity", this.hadGravity);
        return nbt;
    }

    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.hasFallDamage = nbt.func_74767_n("hasFallDamage");
        this.hadGravity = nbt.func_74767_n("hadGravity");
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)user);
        boolean race = props.getRace().equals((Object)CartValues.MODIFIED_HUMAN);
        boolean subRaceCheck = props.getSubRace().equals("no_suit");
        return race && !subRaceCheck;
    }
}

