/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mochi2;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.api.helpers.HakiUsedChecker;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.haki.HaoshokuHakiParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ZanGiriMochiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"zan_giri_mochi", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user grabs their foe and spins them around until they slam them into the ground, causing immense damage. (You can turn off and on the terrain damage)", null)});
    public static final AbilityCore<ZanGiriMochiAbility> INSTANCE = new AbilityCore.Builder("Zan Giri Mochi", AbilityCategory.DEVIL_FRUITS, ZanGiriMochiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)260.0f), ChargeComponent.getTooltip((float)100.0f), CooldownComponent.getTooltip((float)1600.0f), RangeComponent.getTooltip((float)32.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(100, this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.MOCHI_ABILITY, new AbilityPool2[]{ModAbilityPools.GRAB_ABILITY});
    private float yaw;
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    private final AltModeComponent<Mode> altModeComponent;
    private final GrabEntityComponent grabComponent = new GrabEntityComponent((IAbility)this, true, true, false, 27.0f);
    private List<LivingEntity> grabbedEntities = new ArrayList<LivingEntity>();
    private int chargeTime = 120;
    private int holdTime = 40;
    private int cooldown = 1600;
    private int dmg = 180;

    public ZanGiriMochiAbility(AbilityCore<ZanGiriMochiAbility> core) {
        super(core);
        this.isNew = true;
        this.altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.EXPLOSIVE).addChangeModeEvent(this::onAltModeChange);
        super.addComponents(new AbilityComponent[]{this.grabComponent, this.rangeComponent, this.dealDamageComponent, this.chargeComponent, this.continuousComponent, this.poolComponent, this.morphComponent, this.altModeComponent});
        this.addUseEvent(AbilityLimits::usingBrawler);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!(entity.field_70170_p.field_72995_K || this.chargeComponent.isCharging() || this.continuousComponent.isContinuous())) {
            this.chargeComponent.startCharging(entity, 100.0f);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.ZAN_GIRI_MOCHI_NEW.get());
    }

    public void onChargeTick(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.getChargeTime() < 40.0f) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 2, false, false));
        }
        if (!entity.field_70170_p.field_72995_K && this.chargeComponent.getChargeTime() >= 40.0f) {
            float horizontal = 32.0f;
            float vertical = 4.0f;
            List list = WyHelper.getNearbyLiving((Vector3d)entity.func_213303_ch(), (IWorld)entity.field_70170_p, (double)horizontal, (double)vertical, (double)horizontal, (Predicate)ModEntityPredicates.getEnemyFactions((LivingEntity)entity));
            Iterator var4 = list.iterator();
            this.yaw += 30.0f;
            float angleRadians = (float)Math.toRadians(this.yaw);
            float distance = 27.0f;
            double offsetX = Math.cos(angleRadians) * (double)distance;
            double offsetZ = Math.sin(angleRadians) * (double)distance;
            double offsetY = entity.func_70047_e() / 2.0f;
            double posX = entity.func_226277_ct_() + offsetX;
            double posY = entity.func_226278_cu_() + offsetY;
            double posZ = entity.func_226281_cx_() + offsetZ;
            while (var4.hasNext()) {
                LivingEntity target = (LivingEntity)var4.next();
                if (HakiUsedChecker.hasFutureOn(target) || AbilityLimits.hasKamie(target)) continue;
                target.func_195064_c(new EffectInstance((Effect)ModEffects.GRABBED.get(), Integer.MAX_VALUE, 0, false, false));
                target.func_70634_a(posX, posY, posZ);
                this.grabbedEntities.add(target);
            }
            entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 2, 2, false, false));
        }
    }

    public void onChargeEnd(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 40.0f);
    }

    public void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            for (LivingEntity livingEntity : this.grabbedEntities) {
                livingEntity.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_() + 18.0, entity.func_226281_cx_());
                livingEntity.func_195064_c(new EffectInstance(Effects.field_76431_k, 2, 0));
            }
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.ZAN_GIRI.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)(entity.func_226278_cu_() + 3.0), (double)entity.func_226281_cx_());
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 2, false, false));
        }
    }

    public void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            float dmg = 180.0f;
            float explosiveDmg = 30.0f;
            if (this.grabbedEntities.size() > 3) {
                dmg *= 0.6f;
                explosiveDmg *= 0.5f;
            } else if (this.grabbedEntities.size() > 2) {
                dmg *= 0.8f;
                explosiveDmg *= 0.75f;
            }
            for (LivingEntity livingEntity : this.grabbedEntities) {
                livingEntity.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
                if (!this.dealDamageComponent.hurtTarget(entity, livingEntity, dmg)) continue;
                livingEntity.func_195064_c(new EffectInstance(Effects.field_204839_B, 10, 0, false, false));
                livingEntity.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_() - 1.0, entity.func_226281_cx_());
                livingEntity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 90, 0));
                livingEntity.func_195063_d((Effect)ModEffects.GRABBED.get());
                livingEntity.field_70133_I = true;
            }
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (float)22.0f);
            explosion.setExplosionSound(true);
            explosion.setDamageOwner(false);
            if (this.altModeComponent.getCurrentMode() == Mode.EXPLOSIVE) {
                explosion.setDestroyBlocks(true);
                explosion.setFireAfterExplosion(true);
            } else {
                explosion.setDestroyBlocks(false);
                explosion.setFireAfterExplosion(false);
            }
            explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(25));
            explosion.setDamageEntities(true);
            explosion.setStaticDamage(explosiveDmg);
            explosion.doExplosion();
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.HAKI_RELEASE_SFX.get(), SoundCategory.PLAYERS, 4.0f, 0.85f);
            IHakiData hakiProps = HakiDataCapability.get((LivingEntity)entity);
            HaoshokuHakiParticleEffect.Details particleDetails = new HaoshokuHakiParticleEffect.Details();
            Color color = new Color(0xFF0000);
            int radius = 0;
            int haoMastery = 0;
            Interval effectInterval = new Interval(20);
            float haoLevel = hakiProps.getTotalHakiExp() / 100.0f;
            if (haoLevel <= 1.0f) {
                radius = 10;
                haoMastery = 0;
            } else if (haoLevel > 1.0f && haoLevel <= 1.75f) {
                radius = 25;
                haoMastery = 1;
            } else if (haoLevel > 1.75f) {
                radius = 40;
                haoMastery = 2;
            }
            color = new Color(HakiHelper.getHaoshokuColour((LivingEntity)entity));
            LightningDischargeEntity discharge = new LightningDischargeEntity((Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_() + 1.5, entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
            discharge.setAliveTicks(-1);
            discharge.setUpdateRate(8);
            discharge.setLightningLength((float)(radius * 2));
            discharge.setColor(new Color(0, 0, 0, 100));
            discharge.setOutlineColor(color);
            discharge.setRenderTransparent();
            discharge.setDetails(16);
            int density = haoMastery == 2 ? 32 : 16;
            discharge.setDensity(density);
            discharge.setSize(1.0f);
            discharge.setSkipSegments(1);
            if (haoMastery == 0) {
                discharge.setSplit();
            }
            if (discharge != null) {
                discharge.setAliveTicks(30);
            }
            entity.field_70170_p.func_217376_c((Entity)discharge);
            entity.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_() + 14.0, entity.func_226281_cx_());
            this.morphComponent.stopMorph(entity);
            this.grabbedEntities.clear();
            this.cooldownComponent.startCooldown(entity, 1600.0f);
        }
    }

    public ContinuousComponent getContinuousComponent(LivingEntity entity) {
        return this.continuousComponent;
    }

    public ChargeComponent getChargeComponent(LivingEntity entity) {
        return this.chargeComponent;
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.EXPLOSIVE || mode == Mode.NONE) {
            // empty if block
        }
    }

    public static enum Mode {
        EXPLOSIVE,
        NONE;

    }
}

