/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mochi2;

import net.MrMagicalCart.cartaddon.entities.projectiles.mochi.YakiMochiProjectile;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;

public class YakiMochiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"yaki_mochi", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user inflates his forearm until they release it. On release, the pressure explodes and fires a flamming fist that deals great knockback. (When charging this move, the damage and range of the move increases)", null)});
    private static final int COOLDOWN = 450;
    public static final AbilityCore<YakiMochiAbility> INSTANCE = new AbilityCore.Builder("Yaki Mochi", AbilityCategory.DEVIL_FRUITS, YakiMochiAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[0]).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)450.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    protected final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, this.isParallel()).addStartEvent(90, this::startChargingEvent).addTickEvent(90, this::tickChargingEvent).addEndEvent(90, this::endChargingEvent);
    protected final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.MOCHI_ABILITY, new AbilityPool2[0]);
    private int dmg = 45;
    private int lifeTime = 5;

    public YakiMochiAbility(AbilityCore<YakiMochiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.chargeComponent, this.projectileComponent, this.morphComponent});
        this.addUseEvent(200, this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            this.chargeComponent.startCharging(entity, 200.0f);
        }
    }

    private void startChargingEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.YAKI_MOCHI.get());
    }

    private void tickChargingEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && entity.field_82175_bq) {
            this.chargeComponent.stopCharging(entity);
        }
        if (this.chargeComponent.getChargeTime() % 5.0f == 0.0f) {
            ++this.dmg;
            ++this.lifeTime;
        }
    }

    private void endChargingEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.stopMorph(entity);
        this.projectileComponent.shoot(entity, 3.0f, 0.0f);
        this.dmg = 45;
        this.lifeTime = 5;
        this.cooldownComponent.startCooldown(entity, 600.0f);
    }

    private YakiMochiProjectile createProjectile(LivingEntity entity) {
        YakiMochiProjectile proj = new YakiMochiProjectile(entity.field_70170_p, entity, this);
        proj.setDamage(this.dmg);
        proj.setMaxLife(this.lifeTime);
        return proj;
    }

    public boolean isParallel() {
        return false;
    }
}

