/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mochi2;

import java.util.List;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public class SupremeSmashingMochiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"supreme_smashing_mochi", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user creates a massive mochi mace they swing around themselves, dealing massive damage.", null)});
    private static final int HOLD_TIME = 40;
    private static final int COOLDOWN = 600;
    public static final AbilityCore<SupremeSmashingMochiAbility> INSTANCE = new AbilityCore.Builder("Supreme Smashing Mochi", AbilityCategory.DEVIL_FRUITS, SupremeSmashingMochiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{DealDamageComponent.getTooltip((float)5.0f), ContinuousComponent.getTooltip((float)40.0f), CooldownComponent.getTooltip((float)600.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::onContinuityTick).addEndEvent(this::endContinuityEvent);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addOnHitEvent(this::hitEvent);
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.MOCHI_ABILITY, new AbilityPool2[0]);
    private final int damage = 5;

    public SupremeSmashingMochiAbility(AbilityCore<SupremeSmashingMochiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.dealDamageComponent, this.animationComponent, this.rangeComponent, this.hitTriggerComponent, this.continuousComponent, this.morphComponent});
        this.addUseEvent(this::useEvent);
        this.addUseEvent(AbilityLimits::usingBrawler);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            this.continuousComponent.triggerContinuity(entity, 40.0f);
        } else if (this.continuousComponent.isContinuous()) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.SPIN_TO_WIN);
        this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.SUPREME_SMASHING_MOCHI.get());
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (AbilityLimits.cancelBrawler(entity)) {
            this.continuousComponent.stopContinuity(entity);
        }
        List list = this.rangeComponent.getTargetsInArea(entity, 6.0f);
        for (LivingEntity target : list) {
            this.dealDamageComponent.hurtTarget(entity, target, 5.0f);
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 5, 3, false, false));
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.stopMorph(entity);
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 600.0f);
    }

    private boolean hitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        return true;
    }
}

