/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mochi2;

import java.util.List;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.mochi2.MochiHelper;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class RollingMochiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"rolling_mochi", (Pair[])new Pair[]{ImmutablePair.of((Object)"Transforms the user into a donut that rolls with immense speed. When colliding with a target, that target is also dragged with them.", null)});
    public static final AbilityCore<RollingMochiAbility> INSTANCE = new AbilityCore.Builder("Rolling Mochi", AbilityCategory.DEVIL_FRUITS, RollingMochiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)400.0f), ChangeStatsComponent.getTooltip()}).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private static final AbilityAttributeModifier ATTACK_SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_SPEED_UUID, INSTANCE, "Rolling Mochi Attack Speed Modifier", -0.9, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STEP_ASSIST_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STEP_HEIGHT_UUID, INSTANCE, "Rolling Mochi Step Assist Modifier", 15.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier MINING_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_MINING_SPEED_UUID, INSTANCE, "Rolling Mochi Mining Speed Modifier", -1.0, AttributeModifier.Operation.MULTIPLY_BASE);
    protected final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, false).addStartEvent(this::startContinuityEvent).addTickEvent(this::onConinuityTick).addEndEvent(this::stopContinuityEvent);
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    private final DamageTakenComponent damageTakenComponent;
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.MOCHI_ABILITY, new AbilityPool2[0]);
    private final float COOLDOWN = 400.0f;
    private boolean hasFallDamage;

    public RollingMochiAbility(AbilityCore<RollingMochiAbility> core) {
        super(core);
        this.isNew = true;
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_ASSIST_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.MINING_SPEED, (AttributeModifier)MINING_MODIFIER);
        this.damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.rangeComponent, this.dealDamageComponent, this.hitTrackerComponent, this.damageTakenComponent, this.continuousComponent, this.statsComponent, this.morphComponent});
        this.hasFallDamage = true;
        this.addCanUseCheck(MochiHelper::hasHaki);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.hasFallDamage = false;
        this.hitTrackerComponent.clearHits();
        this.continuousComponent.triggerContinuity(entity, 60.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.ROLLING_MOCHI.get());
        this.statsComponent.applyModifiers(entity);
    }

    private void onConinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.func_70089_S() && MochiHelper.hasArmamentOn(entity)) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.MOCHI_LOGIA.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
            Vector3d look = entity.func_70040_Z();
            Vector3d speed = look.func_216372_d(1.55, 0.0, 1.55);
            entity.func_213315_a(MoverType.SELF, speed);
            List targets = this.rangeComponent.getTargetsInArea(entity, 1.25f);
            for (LivingEntity target : targets) {
                if (this.hitTrackerComponent.canHit((Entity)target)) {
                    this.dealDamageComponent.hurtTarget(entity, target, 10.0f);
                }
                if (this.continuousComponent.getContinueTime() % 20.0f != 0.0f) continue;
                this.dealDamageComponent.hurtTarget(entity, target, 1.0f);
            }
            for (LivingEntity target : this.hitTrackerComponent.getHits()) {
                target.func_70634_a(entity.func_226277_ct_() + look.field_72450_a, entity.func_226278_cu_(), entity.func_226281_cx_() + look.field_72449_c);
            }
        } else {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hasFallDamage = true;
        this.morphComponent.stopMorph(entity);
        this.statsComponent.removeModifiers(entity);
        this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
    }

    public float getCooldownTicks() {
        return 400.0f;
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            return 0.0f;
        }
        return damage;
    }

    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74757_a("hasFallDamage", this.hasFallDamage);
        return nbt;
    }

    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.hasFallDamage = nbt.func_74767_n("hasFallDamage");
    }
}

