/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mochi2;

import net.MrMagicalCart.cartaddon.entities.projectiles.mochi.PastryRiverProjectile;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PastryRiverAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"pastry_river", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user charges and summons a large spike of mochi, slowing and stunning anyone caught in it.", null)});
    private static final float COOLDOWN = 400.0f;
    private static final float CHARGE = 100.0f;
    public static final AbilityCore<PastryRiverAbility> INSTANCE = new AbilityCore.Builder("Pastry River", AbilityCategory.DEVIL_FRUITS, PastryRiverAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChargeComponent.getTooltip((float)30.0f), CooldownComponent.getTooltip((float)400.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).build();
    private ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addTickEvent(this::onTickEvent).addEndEvent(this::endTickEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.MOCHI_ABILITY, new AbilityPool2[0]);

    public PastryRiverAbility(AbilityCore<PastryRiverAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.chargeComponent, this.projectileComponent});
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            this.chargeComponent.startCharging(entity, 30.0f);
        }
    }

    private void onTickEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 2, 2, false, false));
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)64.0);
        if (mop.func_216346_c() != RayTraceResult.Type.MISS) {
            double i = mop.func_216347_e().field_72450_a;
            double j = mop.func_216347_e().field_72448_b;
            double k = mop.func_216347_e().field_72449_c;
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.PASTRY_RIVER.get()), (Entity)entity, (double)i, (double)j, (double)k);
        }
    }

    private void endTickEvent(LivingEntity entity, IAbility ability) {
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)64.0);
        if (mop.func_216346_c() != RayTraceResult.Type.MISS) {
            double i = mop.func_216347_e().field_72450_a;
            double j = mop.func_216347_e().field_72448_b;
            double k = mop.func_216347_e().field_72449_c;
            PastryRiverProjectile pastryRiverProjectile = (PastryRiverProjectile)this.projectileComponent.getNewProjectile(entity);
            pastryRiverProjectile.func_70012_b(i, j - 12.0, k, 0.0f, 0.0f);
            pastryRiverProjectile.func_70186_c(0.0, 0.001, 0.0, 1.4f, 0.0f);
            entity.field_70170_p.func_217376_c((Entity)pastryRiverProjectile);
            this.cooldownComponent.startCooldown(entity, 400.0f);
        }
    }

    private PastryRiverProjectile createProjectile(LivingEntity entity) {
        PastryRiverProjectile pastry = new PastryRiverProjectile(entity.field_70170_p, entity);
        return pastry;
    }
}

