/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mochi2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartBlocks;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.yami.AbsorbedBlocksAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.BlockPlacingHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NagareMochiAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"nagare_mochi", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user transforms the ground around them into mochi, slowing enemies and allies alike.", null)});
    private static final int CHARGE_TIME = 100;
    private static final int MAX_COOLDOWN = 600;
    private static final float MIN_COOLDOWN = 400.0f;
    private static final int RANGE = 32;
    public static final AbilityCore<NagareMochiAbility> INSTANCE = new AbilityCore.Builder("Nagare Mochi", AbilityCategory.DEVIL_FRUITS, NagareMochiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChargeComponent.getTooltip((float)100.0f), CooldownComponent.getTooltip((float)400.0f, (float)600.0f), RangeComponent.getTooltip((float)32.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private List<LivingEntity> targets = new ArrayList<LivingEntity>();
    private final BlockPlacingHelper blockPlacingHelper = new BlockPlacingHelper();
    private List<AbsorbedBlocksAbility.BlockData> encasedBlocks = new ArrayList<AbsorbedBlocksAbility.BlockData>();
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.MOCHI_ABILITY, new AbilityPool2[0]);

    public NagareMochiAbility(AbilityCore<NagareMochiAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.poolComponent, this.chargeComponent, this.continuousComponent, this.animationComponent, this.rangeComponent, this.hitTrackerComponent});
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (!this.chargeComponent.isCharging()) {
                this.chargeComponent.startCharging(entity, 100.0f);
            } else if (this.chargeComponent.getChargePercentage() >= 0.2f) {
                this.chargeComponent.stopCharging(entity);
            }
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.blockPlacingHelper.clearList();
            float spread = 0.65f;
            BlockPos.Mutable mutpos = new BlockPos.Mutable();
            for (int i = -32; i < 32; ++i) {
                for (int j = -7; j < 3; ++j) {
                    for (int k = -32; k < 32; ++k) {
                        double posZ;
                        double posY;
                        double posX = entity.func_226277_ct_() + (double)i + (!((double)i < -WyHelper.randomWithRange((int)((int)(32.0f * spread)), (int)((int)(32.0f * (spread + 0.35f))))) && !((double)i > WyHelper.randomWithRange((int)((int)(32.0f * spread)), (int)((int)(32.0f * (spread + 0.35f))))) ? 0.0 : WyHelper.randomWithRange((int)-2, (int)2));
                        if (!AbilityHelper.canPlaceBlock((World)entity.field_70170_p, (double)posX, (double)(posY = entity.func_226278_cu_() + (double)j), (double)(posZ = entity.func_226281_cx_() + (double)k + (!((double)k < -WyHelper.randomWithRange((int)((int)(32.0f * spread)), (int)((int)(32.0f * (spread + 0.35f))))) && !((double)k > WyHelper.randomWithRange((int)((int)(32.0f * spread)), (int)((int)(32.0f * (spread + 0.35f))))) ? 0.0 : WyHelper.randomWithRange((int)-2, (int)2))), (BlockState)((Block)CartBlocks.MOCHI_BLOCK.get()).func_176223_P(), (int)3, (BlockProtectionRule)DefaultProtectionRules.CORE_FOLIAGE_ORE)) continue;
                        mutpos.func_189532_c(posX, posY, posZ);
                        this.blockPlacingHelper.addBlockPos((BlockPos)mutpos, i * i + j * j + k * k);
                    }
                }
            }
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1, false, false));
            Set blockList = this.blockPlacingHelper.getBlockList();
            int finished = blockList.size() / 100;
            int i = 0;
            Iterator iterator = blockList.iterator();
            while (iterator.hasNext()) {
                BlockState oldState;
                BlockPos blockPos = (BlockPos)iterator.next();
                if (finished-- < 0) break;
                if (!entity.field_70170_p.func_180495_p(blockPos.func_177984_a()).func_185904_a().func_76218_k()) {
                    WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.NAGARE_MOCHI.get()), (Entity)entity, (double)blockPos.func_177958_n(), (double)((double)blockPos.func_177956_o() + 0.5), (double)blockPos.func_177952_p());
                }
                if ((oldState = entity.field_70170_p.func_180495_p(blockPos)) != ((Block)CartBlocks.MORI_BLOCK.get()).func_176223_P() && oldState != ((Block)CartBlocks.GORU_BLOCK.get()).func_176223_P() && oldState != ((Block)ModBlocks.DARKNESS.get()).func_176223_P() && AbilityHelper.placeBlockIfAllowed((LivingEntity)entity, (BlockPos)blockPos, (BlockState)((Block)CartBlocks.MOCHI_BLOCK.get()).func_176223_P(), (int)3, (BlockProtectionRule)DefaultProtectionRules.CORE_FOLIAGE_ORE)) {
                    this.encasedBlocks.add(new AbsorbedBlocksAbility.BlockData(oldState, blockPos));
                }
                List targets = this.rangeComponent.getTargetsInArea(entity, blockPos, 1.5f);
                for (LivingEntity target : targets) {
                    if (this.targets.contains(target) || target.func_110124_au() == entity.func_110124_au()) continue;
                    this.targets.add(target);
                    EffectInstance instance = new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1);
                    target.func_195064_c(instance);
                    ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(target.func_145782_y(), instance));
                    WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.NAGARE_MOCHI.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)target.func_226278_cu_(), (double)target.func_226281_cx_());
                }
                ++i;
                iterator.remove();
            }
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.targets.clear();
            this.encasedBlocks = new ArrayList<AbsorbedBlocksAbility.BlockData>();
            this.continuousComponent.stopContinuity(entity);
            this.cooldownComponent.startCooldown(entity, (float)(600.0 * Math.max(0.75, (double)this.chargeComponent.getChargePercentage())));
        }
    }
}

