/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mochi2;

import net.MrMagicalCart.cartaddon.abilities.mochi2.MochiHelper;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.entities.projectiles.mochi.MochiHadanProjectile;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.RepeaterAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class MusoMochiHadanAbility
extends RepeaterAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"muso_mochi_hadan", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user forms a gatling gun with their hands, and shoots multiple bullets out of it. (Requires Armament Haki)", null)});
    private static final int COOLDOWN = 300;
    public static final AbilityCore<MusoMochiHadanAbility> INSTANCE = new AbilityCore.Builder("Muso Mochi Hadan", AbilityCategory.DEVIL_FRUITS, MusoMochiHadanAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)300.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    private float cooldown = 300.0f;
    private int triggers = 18;
    private int interval = 3;

    public MusoMochiHadanAbility(AbilityCore<MusoMochiHadanAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.morphComponent, this.animationComponent});
        this.repeaterComponent.addTriggerEvent(100, this::triggerRepeaterEvent);
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(100, this::endContinuityEvent);
        this.addCanUseCheck(AbilityLimits::usingBrawler);
        this.addCanUseCheck(MochiHelper::hasHaki);
        this.addCanUseCheck(AbilityHelper::requiresOnGround);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.MUSO_MOCHI_HADAN.get());
        this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!MochiHelper.hasArmamentOn(entity)) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.morphComponent.stopMorph(entity);
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PISTOL_SHOOT.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        entity.func_226292_a_(Hand.MAIN_HAND, false);
    }

    public int getMaxTriggers() {
        return this.triggers;
    }

    public int getTriggerInterval() {
        return this.interval;
    }

    public float getRepeaterCooldown() {
        return this.cooldown;
    }

    public AbilityProjectileEntity getProjectileFactory(LivingEntity entity) {
        MochiHadanProjectile proj = new MochiHadanProjectile(entity.field_70170_p, entity, (Ability)this);
        return proj;
    }
}

