/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mochi2;

import java.io.Serializable;
import java.util.EnumSet;
import net.MrMagicalCart.cartaddon.entities.projectiles.mochi.MochiGrabProjectile;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MochiGrabAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"mochi_grab", (Pair[])new Pair[]{ImmutablePair.of((Object)"", null)});
    private static final int COOLDOWN = 400;
    private static final int HOLD_TIME = 40;
    public static final AbilityCore<MochiGrabAbility> INSTANCE = new AbilityCore.Builder("Mochi Grab", AbilityCategory.DEVIL_FRUITS, MochiGrabAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip((float)40.0f), CooldownComponent.getTooltip((float)400.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.MOCHI_ABILITY, new AbilityPool2[]{ModAbilityPools.GRAB_ABILITY});
    private LivingEntity grabbedEntity = null;
    private MochiGrabProjectile proj = null;

    public MochiGrabAbility(AbilityCore<MochiGrabAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.continuousComponent, this.projectileComponent, this.poolComponent});
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 40.0f);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.proj = (MochiGrabProjectile)this.projectileComponent.getNewProjectile(entity);
        this.proj.onEntityImpactEvent = (AbilityProjectileEntity.IOnEntityImpact & Serializable)hit -> {
            this.grabbedEntity = hit;
        };
        entity.field_70170_p.func_217376_c((Entity)this.proj);
        this.proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 3.0f, 0.0f);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (!(this.proj != null && this.proj.func_70089_S() || this.grabbedEntity != null)) {
                this.continuousComponent.stopContinuity(entity);
            } else if (this.grabbedEntity != null && (!this.grabbedEntity.func_70089_S() || AbilityHelper.isGuardBlocking((LivingEntity)this.grabbedEntity))) {
                this.continuousComponent.stopContinuity(entity);
            } else if (this.grabbedEntity != null) {
                this.grabbedEntity.field_70177_z = this.grabbedEntity.field_70126_B;
                this.grabbedEntity.field_70125_A = this.grabbedEntity.field_70127_C;
                this.grabbedEntity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1));
                if (this.continuousComponent.getContinueTime() % 2.0f == 0.0f) {
                    WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.MOCHI_GRAB.get()), (Entity)this.grabbedEntity, (double)this.grabbedEntity.func_226277_ct_(), (double)this.grabbedEntity.func_226278_cu_(), (double)this.grabbedEntity.func_226281_cx_());
                }
                double distance = 4.0;
                Vector3d lookVec = entity.func_70040_Z();
                Vector3d pos = new Vector3d(lookVec.field_72450_a * distance, (double)entity.func_70047_e() / 2.0 + lookVec.field_72448_b * distance, lookVec.field_72449_c * distance);
                AbilityHelper.setDeltaMovement((Entity)this.grabbedEntity, (Vector3d)entity.func_213303_ch().func_178787_e(pos).func_178788_d(this.grabbedEntity.func_213303_ch()));
                if (this.grabbedEntity instanceof ServerPlayerEntity) {
                    EnumSet<SPlayerPositionLookPacket.Flags> flags = EnumSet.of(SPlayerPositionLookPacket.Flags.X, SPlayerPositionLookPacket.Flags.Y, SPlayerPositionLookPacket.Flags.Z);
                    ((ServerPlayerEntity)this.grabbedEntity).field_71135_a.func_175089_a(this.grabbedEntity.func_226277_ct_(), this.grabbedEntity.func_226278_cu_(), this.grabbedEntity.func_226281_cx_(), this.grabbedEntity.field_70126_B, this.grabbedEntity.field_70127_C, flags);
                }
                this.grabbedEntity.field_70143_R = 0.0f;
            }
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.proj = null;
        this.grabbedEntity = null;
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    private MochiGrabProjectile createProjectile(LivingEntity entity) {
        MochiGrabProjectile proj = new MochiGrabProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

