/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mochi2;

import java.util.ArrayList;
import java.util.List;
import net.MrMagicalCart.cartaddon.abilities.mochi2.MochiHelper;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.entities.projectiles.mochi.AnemoneProjectile;
import net.MrMagicalCart.cartaddon.entities.projectiles.mochi.DonutProjectile;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MochiGinchakuNewAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"mochi_ginchaku", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user creates donuts all around themselves, which enable them to summon devastation upon their worst foe.", null)});
    private static final int COOLDOWN = 400;
    private static final int HOLD_TIME = 100;
    private static final int CHARGE_TIME = 10;
    public static final AbilityCore<MochiGinchakuNewAbility> INSTANCE = new AbilityCore.Builder("Mochi Ginchaku", AbilityCategory.DEVIL_FRUITS, MochiGinchakuNewAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChargeComponent.getTooltip((float)10.0f), ContinuousComponent.getTooltip((float)100.0f), CooldownComponent.getTooltip((float)400.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(100, this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.MOCHI_ABILITY, new AbilityPool2[0]);
    private List<DonutProjectile> donuts = new ArrayList<DonutProjectile>();
    Vector3d position = null;

    public MochiGinchakuNewAbility(AbilityCore<MochiGinchakuNewAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.poolComponent, this.chargeComponent, this.continuousComponent, this.projectileComponent});
        super.addCanUseCheck(MochiHelper::hasHaki);
        super.addCanUseCheck(AbilityLimits::usingBrawler);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous() && !this.chargeComponent.isCharging()) {
            this.chargeComponent.startCharging(entity, 10.0f);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        for (int i = 0; i < 14; ++i) {
            DonutProjectile donutEntity = new DonutProjectile(entity.field_70170_p, entity, this);
            donutEntity.func_212361_a((Entity)entity);
            entity.field_70170_p.func_217376_c((Entity)donutEntity);
            this.donuts.add(donutEntity);
        }
    }

    public void onChargeTick(LivingEntity entity, IAbility ability) {
        RayTraceResult mop;
        if (!MochiHelper.hasArmamentOn(entity) || AbilityLimits.cancelBrawler(entity)) {
            this.chargeComponent.stopCharging(entity);
        }
        if ((mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)64.0)).func_216346_c() != RayTraceResult.Type.MISS) {
            double i = mop.func_216347_e().field_72450_a;
            double j = mop.func_216347_e().field_72448_b;
            double k = mop.func_216347_e().field_72449_c;
            this.position = new Vector3d(i, j, k);
        }
        entity.func_195064_c(new EffectInstance(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 0, false, false)));
        for (DonutProjectile proj : this.donuts) {
            double ranVerticalAngle = Math.toRadians(entity.func_70681_au().nextDouble() * 180.0 - 90.0);
            double ranHorizontalAngle = Math.toRadians(entity.func_70681_au().nextDouble() * 360.0);
            double xPos = Math.cos(ranVerticalAngle) * Math.cos(ranHorizontalAngle);
            double zPos = Math.cos(ranVerticalAngle) * Math.sin(ranHorizontalAngle);
            double yPos = Math.sin(ranVerticalAngle);
            Vector3d vector3d = new Vector3d(xPos, yPos, zPos);
            Vector3d pos = vector3d.func_186678_a(15.0).func_178787_e(this.position);
            if (!proj.getSetPos()) {
                proj.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            }
            proj.func_200602_a(EntityAnchorArgument.Type.FEET, this.position);
            proj.setSetPos(true);
            proj.field_70125_A = -proj.field_70125_A;
            proj.field_70177_z = -proj.field_70177_z;
        }
        for (DonutProjectile donut : this.donuts) {
            if (!(donut.func_226278_cu_() < entity.func_226278_cu_())) continue;
            donut.func_70106_y();
        }
    }

    public void onChargeEnd(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 100.0f);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!MochiHelper.hasArmamentOn(entity) || AbilityLimits.cancelBrawler(entity)) {
            this.continuousComponent.stopContinuity(entity);
        }
        entity.func_195064_c(new EffectInstance(new EffectInstance(Effects.field_76421_d, 2, 2, false, false)));
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)64.0);
        if (mop.func_216346_c() != RayTraceResult.Type.MISS) {
            double i = mop.func_216347_e().field_72450_a;
            double j = mop.func_216347_e().field_72448_b;
            double k = mop.func_216347_e().field_72449_c;
            if (this.continuousComponent.getContinueTime() % 2.0f == 0.0f) {
                this.position = new Vector3d(i, j, k);
            }
        }
        for (DonutProjectile donut : this.donuts) {
            donut.func_200602_a(EntityAnchorArgument.Type.FEET, this.position);
            donut.field_70125_A = -donut.field_70125_A;
            donut.field_70177_z = -donut.field_70177_z;
            if (this.continuousComponent.getContinueTime() % 15.0f != 0.0f) continue;
            AnemoneProjectile anemoneProjectile = new AnemoneProjectile(entity.field_70170_p, entity, this);
            anemoneProjectile.func_212361_a((Entity)entity);
            anemoneProjectile.func_225653_b_(donut.func_226277_ct_(), donut.func_226278_cu_(), donut.func_226281_cx_());
            anemoneProjectile.func_200602_a(EntityAnchorArgument.Type.FEET, this.position);
            anemoneProjectile.field_70125_A = -anemoneProjectile.field_70125_A;
            anemoneProjectile.field_70177_z = -anemoneProjectile.field_70177_z;
            entity.field_70170_p.func_217376_c((Entity)anemoneProjectile);
            double speed = 2.5;
            anemoneProjectile.func_213293_j(-(anemoneProjectile.func_70040_Z().field_72450_a * speed), -(anemoneProjectile.func_70040_Z().field_72448_b * speed), anemoneProjectile.func_70040_Z().field_72449_c * speed);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        for (DonutProjectile donut : this.donuts) {
            if (donut == null) continue;
            donut.func_70106_y();
        }
        this.donuts.clear();
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    private AnemoneProjectile createProjectile(LivingEntity entity) {
        AnemoneProjectile proj = new AnemoneProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

