/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mochi2;

import net.MrMagicalCart.cartaddon.abilities.mochi2.MochiHelper;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.entities.projectiles.mochi.DownSlamMochiProjectile;
import net.MrMagicalCart.cartaddon.entities.projectiles.mochi.MochiBarrageProjectile;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MochiBarrageNewAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"mochi_barrage", (Pair[])new Pair[]{ImmutablePair.of((Object)"", null)});
    private static final int COOLDOWN = 400;
    private static final int CHARGE_TIME = 60;
    private static final int CONT_TIME = 60;
    public static final AbilityCore<MochiBarrageNewAbility> INSTANCE = new AbilityCore.Builder("Mochi Barrage", AbilityCategory.DEVIL_FRUITS, MochiBarrageNewAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChargeComponent.getTooltip((float)60.0f), ContinuousComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)300.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(100, this::startChargeEvent).addTickEvent(this::onChargeTick).addEndEvent(100, this::endChargeEvent);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::getProjectileFactory);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::onContinuityTick).addEndEvent(this::endContinuityEvent);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.MOCHI_ABILITY, new AbilityPool2[0]);
    private LivingEntity target;
    private float spread = 3.25f;

    public MochiBarrageNewAbility(AbilityCore<MochiBarrageNewAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.continuousComponent, this.chargeComponent, this.animationComponent, this.projectileComponent});
        this.addCanUseCheck(MochiHelper::hasHaki);
        this.addCanUseCheck(AbilityHelper::requiresOnGround);
        this.addCanUseCheck(AbilityLimits::usingBrawler);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging() && !this.continuousComponent.isContinuous()) {
            this.chargeComponent.startCharging(entity, 40.0f);
        } else {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.RAISE_RIGHT_ARM);
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!MochiHelper.hasArmamentOn(entity)) {
            this.continuousComponent.stopContinuity(entity);
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 2, 2, false, false));
        RayTraceResult mop = null;
        if (this.target == null) {
            mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)28.0);
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (this.target != null) {
            x = this.target.func_226277_ct_();
            y = this.target.func_226278_cu_();
            z = this.target.func_226281_cx_();
        } else {
            if (mop == null) {
                return;
            }
            x = mop.func_216347_e().field_72450_a;
            y = mop.func_216347_e().field_72448_b;
            z = mop.func_216347_e().field_72449_c;
        }
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.MOCHI_BARRAGE.get()), (Entity)entity, (double)x, (double)(y + 6.5), (double)z);
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 60.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!MochiHelper.hasArmamentOn(entity)) {
            this.continuousComponent.stopContinuity(entity);
        }
        RayTraceResult mop = null;
        if (this.target == null && this.continuousComponent.getContinueTime() % 2.0f == 0.0f) {
            mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)28.0);
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 0, false, false));
        if (this.continuousComponent.getContinueTime() % 4.0f == 0.0f) {
            for (int a = 0; a < 3; ++a) {
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                if (this.target != null) {
                    x = this.target.func_226277_ct_();
                    y = this.target.func_226278_cu_();
                    z = this.target.func_226281_cx_();
                } else {
                    if (mop == null) {
                        return;
                    }
                    x = mop.func_216347_e().field_72450_a;
                    y = mop.func_216347_e().field_72448_b;
                    z = mop.func_216347_e().field_72449_c;
                }
                double i = x + WyHelper.randomDouble() * (double)this.spread;
                double j = y + WyHelper.randomDouble() * 2.0;
                double k = z + WyHelper.randomDouble() * (double)this.spread;
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.MOCHI_BARRAGE.get()), (Entity)entity, (double)x, (double)(y + 6.5), (double)z);
                MochiBarrageProjectile mochiBarrageProjectile = (MochiBarrageProjectile)this.projectileComponent.getNewProjectile(entity);
                mochiBarrageProjectile.func_70107_b(i, j + 6.5, k);
                AbilityHelper.setDeltaMovement((Entity)mochiBarrageProjectile, (double)0.0, (double)-1.75, (double)0.0);
                entity.field_70170_p.func_217376_c((Entity)mochiBarrageProjectile);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    public AbilityProjectileEntity getProjectileFactory(LivingEntity entity) {
        AbilityProjectileEntity projectileEntity = new DownSlamMochiProjectile(entity.field_70170_p, entity, this);
        projectileEntity = new MochiBarrageProjectile(entity.field_70170_p, entity, this);
        projectileEntity.field_70125_A = 1.5f;
        return projectileEntity;
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }
}

