/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mochi2;

import javax.annotation.Nullable;
import net.MrMagicalCart.cartaddon.abilities.mochi2.MochiHelper;
import net.MrMagicalCart.cartaddon.entities.mobs.ability.KuriMochiEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;

public class KuriMochiNewAbility
extends Ability {
    private static final int HOLD_TIME = 400;
    private static final int COOLDOWN = 1000;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"kuri_mochi", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user summons a spiky donut that fires spikes at their opponents. (Requires Armament Haki)", null)});
    public static final AbilityCore<KuriMochiNewAbility> INSTANCE = new AbilityCore.Builder("Kuri Mochi", AbilityCategory.DEVIL_FRUITS, KuriMochiNewAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip((float)400.0f), CooldownComponent.getTooltip((float)1000.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::startContinuityEvent).addTickEvent(100, this::onTickEvent).addEndEvent(100, this::stopContinuityEvent);
    private KuriMochiEntity kuriMochiEntity = null;

    public KuriMochiNewAbility(AbilityCore<KuriMochiNewAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent});
        this.addCanUseCheck(MochiHelper::hasHaki);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 400.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.kuriMochiEntity = new KuriMochiEntity(entity.field_70170_p, entity);
        this.kuriMochiEntity.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
        entity.field_70170_p.func_217376_c((Entity)this.kuriMochiEntity);
    }

    private void onTickEvent(LivingEntity entity, IAbility ability) {
        if (this.kuriMochiEntity == null || !this.kuriMochiEntity.func_70089_S()) {
            this.continuousComponent.stopContinuity(entity);
        }
        if (!MochiHelper.hasArmamentOn(entity)) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.kuriMochiEntity != null || !MochiHelper.hasArmamentOn(entity)) {
            this.kuriMochiEntity.func_70106_y();
        }
        this.cooldownComponent.startCooldown(entity, 1000.0f);
    }

    @Nullable
    public KuriMochiEntity getKuriMochiEntity() {
        return this.kuriMochiEntity;
    }

    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        return nbt;
    }

    public void load(CompoundNBT nbt) {
        super.load(nbt);
    }
}

