/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mochi2;

import java.util.List;
import net.MrMagicalCart.cartaddon.abilities.mochi2.MochiHelper;
import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class KashiwaMochiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"kashiwa_mochi", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user charges and creates two arms, which clap together, stunning anyone who gets in the way. (Requires Armament haki)", null), ImmutablePair.of((Object)"The user charges and creates two arms, which slam the ground, launching anyone who gets in their way. (Requires Armament haki)", null)});
    private static final int COOLDOWN = 300;
    private static final int CHARGE_TIME = 10;
    private static final float DAMAGE = 35.0f;
    public static final AbilityCore<KashiwaMochiAbility> INSTANCE;
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::onContinuityTick).addEndEvent(this::endContinuityEvent);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargingEvent).addTickEvent(this::onChargeTick).addEndEvent(this::endChargeEvent);
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final AltModeComponent<Mode> altModeComponent;
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.MOCHI_ABILITY, new AbilityPool2[0]);
    private static final TranslationTextComponent KASHOWA_NAME;
    private static final TranslationTextComponent MUSO_SLAM_NAME;
    private static final ResourceLocation KASHOWA_ICON;
    private static final ResourceLocation MUSO_SLAM_ICON;

    public KashiwaMochiAbility(AbilityCore<KashiwaMochiAbility> core) {
        super(core);
        this.isNew = true;
        this.altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.CLAP).addChangeModeEvent(this::onAltModeChange);
        super.addComponents(new AbilityComponent[]{this.altModeComponent, this.dealDamageComponent, this.hitTrackerComponent, this.rangeComponent, this.morphComponent, this.chargeComponent, this.continuousComponent});
        this.addCanUseCheck(MochiHelper::hasHaki);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous() && !this.chargeComponent.isCharging()) {
            this.chargeComponent.startCharging(entity, 10.0f);
        }
    }

    private void startChargingEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.CLAP) {
            this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.KASHIWA_MOCHI.get());
        } else if (this.altModeComponent.getCurrentMode() == Mode.SLAM) {
            this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.MUSO_DONUT_SLAM.get());
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 2, 0, false, false));
        if (!MochiHelper.hasArmamentOn(entity)) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 10.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        List targets = this.rangeComponent.getTargetsInLine(entity, 3.0f, 3.0f);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
            this.dealDamageComponent.hurtTarget(entity, target, 35.0f);
            if (this.altModeComponent.getCurrentMode() == Mode.CLAP) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 60, 0, false, false));
            } else if (this.altModeComponent.getCurrentMode() == Mode.SLAM) {
                AbilityHelper.setDeltaMovement((Entity)target, (double)0.0, (double)1.75, (double)0.0);
            }
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 40, 0, false, false));
            target.func_195064_c(new EffectInstance(Effects.field_76431_k, 40, 0, false, false));
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.stopMorph(entity);
        this.hitTrackerComponent.clearHits();
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (!this.chargeComponent.isCharging() && !this.continuousComponent.isContinuous()) {
            if (mode == Mode.CLAP) {
                super.setDisplayName((ITextComponent)KASHOWA_NAME);
                super.setDisplayIcon(KASHOWA_ICON);
            } else if (mode == Mode.SLAM) {
                super.setDisplayName((ITextComponent)MUSO_SLAM_NAME);
                super.setDisplayIcon(MUSO_SLAM_ICON);
            }
        }
    }

    static {
        KASHOWA_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.kashiwa_mochi", "Kashiwa Mochi"));
        MUSO_SLAM_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.muso_donut_slam", "Muso Donut Slam"));
        KASHOWA_ICON = new ResourceLocation("cartaddon", "textures/abilities/kashiwa_mochi.png");
        MUSO_SLAM_ICON = new ResourceLocation("cartaddon", "textures/abilities/muso_donut_slam.png");
        INSTANCE = new AbilityCore.Builder("Kashiwa Mochi", AbilityCategory.DEVIL_FRUITS, KashiwaMochiAbility::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> KASHOWA_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], DealDamageComponent.getTooltip((float)35.0f), CooldownComponent.getTooltip((float)300.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> MUSO_SLAM_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], DealDamageComponent.getTooltip((float)35.0f), CooldownComponent.getTooltip((float)300.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    }

    public static enum Mode {
        CLAP,
        SLAM;

    }
}

