/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mochi2;

import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.mochi2.MochiHelper;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.entities.projectiles.mochi.KakuMochiProjectile;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.RepeaterAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class KakuMochiNewAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"kaku_mochi", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user hardens their arms into a square like shape, increasing defense and offense. (Requires Armament haki)", null), ImmutablePair.of((Object)"The user hardens their arms into a square like shape, and brings them up to defend themselves for a short while. (Requires Armament haki)", null), ImmutablePair.of((Object)"The user hardens their arms into a square like shape, and launches a barrage of punches with short range. (Requires Armament haki)", null)});
    public static final AbilityCore<KakuMochiNewAbility> INSTANCE;
    private static final AbilityAttributeModifier KNOCKBACK_RESIST_MODIFIER;
    private static final AbilityAttributeModifier ARMOR_MODIFIER;
    private static final AbilityAttributeModifier STRENGTH_MODIFIER;
    private static final AbilityAttributeModifier ATTACK_SPEED_MODIFIER;
    private static final AbilityAttributeModifier REACH_MODIFIER;
    private static final AbilityAttributeModifier ARMOR_TOUGHNESS_MODIFIER;
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER;
    protected final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::onContinuityTick).addEndEvent(this::stopContinuityEvent);
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    private final AltModeComponent<Mode> altModeComponent;
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.TEKKAI_LIKE, new AbilityPool2[]{CartAbilityPools.MOCHI_ABILITY});
    protected final RepeaterComponent repeaterComponent = new RepeaterComponent((IAbility)this).addTriggerEvent(200, this::onRepeaterTrigger).addStopEvent(200, this::onRepeaterStop);
    protected final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::getProjectileFactory);
    private RepeaterAbility2.IOnTriggerShootEvent customShootLogic = null;
    private int maxTriggers = 12;
    private int triggerInterval = 3;
    private float projectileSpeed = 1.2f;
    private int projectileSpread = 2;
    private int STANDARD_COOLDOWN = 200;
    private int GUARD_COOLDOWN = 600;
    private int GATLING_COOLDOWN = 500;
    private int STANDARD_MAX_COOLDOWN = 600;
    private int GUARD_MAX_COOLDOWN = 800;
    private int GATLING_MAX_COOLDOWN = 500;
    private static final TranslationTextComponent STANDARD_NAME;
    private static final TranslationTextComponent GUARD_NAME;
    private static final TranslationTextComponent GATLING_NAME;
    private static final ResourceLocation STANDARD_ICON;
    private static final ResourceLocation GUARD_ICON;
    private static final ResourceLocation GATLING_ICON;

    public KakuMochiNewAbility(AbilityCore<KakuMochiNewAbility> core) {
        super(core);
        this.isNew = true;
        this.statsComponent.addAttributeModifier(Attributes.field_233820_c_, (AttributeModifier)KNOCKBACK_RESIST_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)ARMOR_TOUGHNESS_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER);
        this.altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.STANDARD).addChangeModeEvent(this::onAltModeChange);
        this.addComponents(new AbilityComponent[]{this.projectileComponent, this.repeaterComponent, this.altModeComponent, this.continuousComponent, this.statsComponent, this.morphComponent, this.animationComponent, this.poolComponent});
        this.setCustomShootLogic(living -> {
            for (int i = 0; i < 5; ++i) {
                this.projectileComponent.shootWithSpread(living, this.projectileSpeed, 3.0f, this.projectileSpread);
            }
        });
        this.addCanUseCheck(MochiHelper::hasHaki);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            if (this.altModeComponent.getCurrentMode() == Mode.STANDARD) {
                this.continuousComponent.triggerContinuity(entity, 400.0f);
            } else if (this.altModeComponent.getCurrentMode() == Mode.GUARD) {
                this.continuousComponent.triggerContinuity(entity, 100.0f);
            } else if (this.altModeComponent.getCurrentMode() == Mode.GATLING) {
                this.continuousComponent.startContinuity(entity);
            }
        } else {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.KAKU_MOCHI.get());
        if (this.altModeComponent.getCurrentMode() == Mode.STANDARD) {
            this.statsComponent.applyModifiers(entity);
        } else if (this.altModeComponent.getCurrentMode() == Mode.GUARD) {
            this.animationComponent.start(entity, ModAnimations.CROSSED_ARMS);
        } else if (this.altModeComponent.getCurrentMode() == Mode.GATLING) {
            this.animationComponent.start(entity, ModAnimations.PUNCH_RUSH);
            this.repeaterComponent.start(entity, this.maxTriggers, this.triggerInterval);
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!MochiHelper.hasArmamentOn(entity)) {
            this.continuousComponent.stopContinuity(entity);
        }
        if (!entity.field_70170_p.field_72995_K) {
            if (this.altModeComponent.getCurrentMode() == Mode.GUARD) {
                entity.func_195064_c(new EffectInstance((Effect)ModEffects.GUARDING.get(), 2, 1, false, false));
                AbilityHelper.setDeltaMovement((Entity)entity, (double)0.0, (double)-5.0, (double)0.0);
            } else if (this.altModeComponent.getCurrentMode() == Mode.GATLING) {
                entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 2, 2, false, false));
            }
        }
    }

    private void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.stopMorph(entity);
        if (this.altModeComponent.getCurrentMode() == Mode.STANDARD) {
            this.statsComponent.removeModifiers(entity);
        } else if (this.altModeComponent.getCurrentMode() == Mode.GUARD) {
            this.animationComponent.stop(entity);
        } else if (this.altModeComponent.getCurrentMode() == Mode.GATLING) {
            this.animationComponent.stop(entity);
        }
        this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
    }

    public float getCooldownTicks() {
        if (this.altModeComponent.getCurrentMode() == Mode.STANDARD) {
            return 200.0f + this.continuousComponent.getContinueTime();
        }
        if (this.altModeComponent.getCurrentMode() == Mode.GUARD) {
            return 600.0f + this.continuousComponent.getContinueTime() * 2.0f;
        }
        if (this.altModeComponent.getCurrentMode() == Mode.GATLING) {
            return 500.0f;
        }
        return 100.0f;
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (!this.continuousComponent.isContinuous()) {
            if (mode == Mode.STANDARD) {
                super.setDisplayName((ITextComponent)STANDARD_NAME);
                super.setDisplayIcon(STANDARD_ICON);
            } else if (mode == Mode.GUARD) {
                super.setDisplayName((ITextComponent)GUARD_NAME);
                super.setDisplayIcon(GUARD_ICON);
            } else if (mode == Mode.GATLING) {
                super.setDisplayName((ITextComponent)GATLING_NAME);
                super.setDisplayIcon(GATLING_ICON);
            }
        }
    }

    private void onRepeaterTrigger(LivingEntity entity, IAbility ability) {
        if (super.canUse(entity).isFail() || AbilityLimits.cancelBrawler(entity)) {
            this.repeaterComponent.stop(entity);
        }
        if (this.customShootLogic != null) {
            this.customShootLogic.customShootLogic(entity);
        } else {
            this.projectileComponent.shoot(entity, this.projectileSpeed, (float)this.projectileSpread);
        }
    }

    private void onRepeaterStop(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
    }

    public void setCustomShootLogic(RepeaterAbility2.IOnTriggerShootEvent event) {
        this.customShootLogic = event;
    }

    public AbilityProjectileEntity getProjectileFactory(LivingEntity entity) {
        int ran = (int)Math.random() * 100;
        KakuMochiProjectile proj = ran < 50 ? new KakuMochiProjectile(entity.field_70170_p, entity, this) : new KakuMochiProjectile(entity.field_70170_p, entity);
        if (this.continuousComponent.getContinueTime() > 20.0f) {
            proj.setKnockbackStrength(7);
        }
        return proj;
    }

    static {
        STANDARD_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.kaku_mochi", "Kaku Mochi"));
        GUARD_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.kaku_guard_mochi", "Kaku Guard Mochi"));
        GATLING_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.kaku_gatling_mochi", "Kaku Gatling Mochi"));
        STANDARD_ICON = new ResourceLocation("cartaddon", "textures/abilities/kaku_mochi.png");
        GUARD_ICON = new ResourceLocation("cartaddon", "textures/abilities/kaku_guard_mochi.png");
        GATLING_ICON = new ResourceLocation("cartaddon", "textures/abilities/kaku_gatling_mochi.png");
        INSTANCE = new AbilityCore.Builder("Kaku Mochi", AbilityCategory.DEVIL_FRUITS, KakuMochiNewAbility::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> STANDARD_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], CooldownComponent.getTooltip((float)200.0f, (float)600.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> GUARD_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], CooldownComponent.getTooltip((float)600.0f, (float)800.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> GATLING_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[2], CooldownComponent.getTooltip((float)500.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).build();
        KNOCKBACK_RESIST_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_KNOCKBACK_RESISTANCE_UUID, INSTANCE, "Kaku Mochi Knockback Resistance Modifier", 3.0, AttributeModifier.Operation.ADDITION);
        ARMOR_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_UUID, INSTANCE, "Kaku Mochi Armor Modifier", 10.0, AttributeModifier.Operation.ADDITION);
        STRENGTH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STRENGTH_UUID, INSTANCE, "Kaku Mochi Strength Modifier", 8.0, AttributeModifier.Operation.ADDITION);
        ATTACK_SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_SPEED_UUID, INSTANCE, "Kaku Mochi Attack Speed Modifier", 0.45, AttributeModifier.Operation.ADDITION);
        REACH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_REACH_UUID, INSTANCE, "Kaku Mochi Reach Modifier", 1.0, AttributeModifier.Operation.ADDITION);
        ARMOR_TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_TOUGHNESS_UUID, INSTANCE, "Kaku Mochi Armor Toughness Modifier", 4.0, AttributeModifier.Operation.ADDITION);
        TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_TOUGHNESS_UUID, INSTANCE, "Kaku Mochi Toughness Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    }

    public static enum Mode {
        STANDARD,
        GUARD,
        GATLING;

    }
}

