/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mochi2;

import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.entities.projectiles.mochi.GatlingMochiProjectile;
import net.MrMagicalCart.cartaddon.entities.projectiles.mochi.MochiBetterElephantGunProjectile;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.brawler.SpinningBrawlAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.RepeaterAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GatlingMochiAbility
extends RepeaterAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"gatling_mochi", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user launches a barrage of punches similar to Gomu Gomu no Jet Gatling.", null), ImmutablePair.of((Object)"The user launches a barrage of large punches similar to Gomu Gomu no Elephant Gatling.", null)});
    private static final TranslationTextComponent GATLING_MOCHI_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.gatling_mochi", "Gatling Mochi"));
    private static final TranslationTextComponent MOCHI_BETTER_ELEPHANT_GUN_NAME = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.giant_gatling_mochi", "Giant Gatling Mochi"));
    private static final ResourceLocation GATLING_MOCHI_ICON = new ResourceLocation("cartaddon", "textures/abilities/gatling_mochi.png");
    private static final ResourceLocation MOCHI_BETTER_ELEPHANT_GUN_ICON = new ResourceLocation("cartaddon", "textures/abilities/giant_gatling_mochi.png");
    private static final int GATLING_MOCHI_COOLDOWN = 400;
    private static final int GATLING_MOCHI_TRIGGERS = 20;
    private static final int GATLING_MOCHI_INTERVAL = 3;
    private static final int MOCHI_BETTER_ELEPHANT_GUN_COOLDOWN = 1000;
    private static final int MOCHI_BETTER_ELEPHANT_GUN_TRIGGERS = 7;
    private static final int MOCHI_BETTER_ELEPHANT_GUN_INTERVAL = 12;
    public static final AbilityCore<GatlingMochiAbility> INSTANCE = new AbilityCore.Builder("Gatling Mochi", AbilityCategory.DEVIL_FRUITS, GatlingMochiAbility::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> GATLING_MOCHI_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], CooldownComponent.getTooltip((float)400.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> MOCHI_BETTER_ELEPHANT_GUN_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], CooldownComponent.getTooltip((float)1000.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final AltModeComponent<Mode> altModeComponent;
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.MOCHI_ABILITY, new AbilityPool2[0]);
    private float projectileSpeed;
    private int projectileSpread;
    private float cooldown = 1000.0f;
    private int triggers = 14;
    private int interval;

    public GatlingMochiAbility(AbilityCore<GatlingMochiAbility> core) {
        super(core);
        this.altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.GATLING).addChangeModeEvent(this::onAltModeChange);
        if (this.altModeComponent.getCurrentMode() == Mode.GATLING) {
            this.interval = 3;
            this.setDisplayIcon(GATLING_MOCHI_ICON);
            this.setDisplayName((ITextComponent)GATLING_MOCHI_NAME);
        } else {
            this.interval = 14;
            this.setDisplayIcon(MOCHI_BETTER_ELEPHANT_GUN_ICON);
            this.setDisplayName((ITextComponent)MOCHI_BETTER_ELEPHANT_GUN_NAME);
        }
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.altModeComponent, this.morphComponent, this.animationComponent});
        this.setCustomShootLogic(living -> {
            for (int i = 0; i < 5; ++i) {
                this.projectileComponent.shootWithSpread(living, this.projectileSpeed, 3.0f, this.projectileSpread);
            }
        });
        this.repeaterComponent.addTriggerEvent(100, this::triggerRepeaterEvent);
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(100, this::endContinuityEvent);
        this.addCanUseCheck(this::usingBrawler);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.PUNCH_RUSH);
        if (this.altModeComponent.getCurrentMode() == Mode.GIANT) {
            if (entity.func_110143_aJ() > entity.func_110138_aP() / 2.0f) {
                Vector3d speed = WyHelper.propulsion((LivingEntity)entity, (double)1.05, (double)1.05);
                AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)2.5, (double)speed.field_72449_c);
            }
        } else {
            this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.GATLING_MOCHI.get());
        }
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1, false, false));
        if (this.altModeComponent.getCurrentMode() == Mode.GATLING) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.MOCHI_LOGIA.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        } else if (this.altModeComponent.getCurrentMode() == Mode.GIANT) {
            AbilityHelper.slowEntityFall((LivingEntity)entity);
        }
        if (AbilityLimits.cancelBrawler(entity)) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.morphComponent.stopMorph(entity);
        if (this.altModeComponent.getCurrentMode() == Mode.GATLING) {
            this.cooldownComponent.startCooldown(entity, 400.0f);
        } else {
            this.cooldownComponent.startCooldown(entity, 1000.0f);
        }
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        entity.func_226292_a_(Hand.MAIN_HAND, false);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.GIANT) {
            super.setDisplayName((ITextComponent)MOCHI_BETTER_ELEPHANT_GUN_NAME);
            super.setDisplayIcon(MOCHI_BETTER_ELEPHANT_GUN_ICON);
            this.triggers = 7;
            this.interval = 12;
        } else if (mode == Mode.GATLING) {
            super.setDisplayName((ITextComponent)GATLING_MOCHI_NAME);
            super.setDisplayIcon(GATLING_MOCHI_ICON);
            this.triggers = 20;
            this.interval = 3;
        }
    }

    public int getMaxTriggers() {
        return this.triggers;
    }

    public int getTriggerInterval() {
        return this.interval;
    }

    public float getRepeaterCooldown() {
        return this.cooldown;
    }

    public AbilityProjectileEntity getProjectileFactory(LivingEntity entity) {
        AbilityProjectileEntity projectile = null;
        float projDmageReduction = 0.8f;
        if (this.altModeComponent.getCurrentMode() == Mode.GIANT) {
            projectile = new MochiBetterElephantGunProjectile(entity.field_70170_p, entity, (Ability)this);
            projectile.setEntityCollisionSize(2.5);
            this.projectileSpeed = 1.8f;
            this.projectileSpread = 4;
            projDmageReduction = 0.65f;
        } else {
            projectile = new GatlingMochiProjectile(entity.field_70170_p, entity, (Ability)this);
            projectile.setEntityCollisionSize(1.25);
            this.projectileSpread = 2;
            this.projectileSpeed = 2.2f;
        }
        projectile.setDamage(projectile.getDamage() * (1.0f - projDmageReduction));
        projectile.setMaxLife((int)((double)projectile.getMaxLife() * 0.75));
        return projectile;
    }

    private AbilityUseResult usingBrawler(LivingEntity entity, IAbility ability) {
        boolean spinActive;
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        SpinningBrawlAbility spinningBrawlAbility = (SpinningBrawlAbility)abilityProps.getEquippedAbility(SpinningBrawlAbility.INSTANCE);
        boolean bl = spinActive = spinningBrawlAbility != null && (spinningBrawlAbility.isContinuous() || spinningBrawlAbility.isCharging());
        if (spinActive) {
            TranslationTextComponent text = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_TOGETHER, new Object[]{this.getDisplayName().getString(), SpinningBrawlAbility.INSTANCE.getUnlocalizedName()});
            return AbilityUseResult.fail((ITextComponent)text);
        }
        return AbilityUseResult.success();
    }

    public static enum Mode {
        GATLING,
        GIANT;

    }
}

