/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mochi2;

import net.MrMagicalCart.cartaddon.init.CartItems;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ItemSpawnComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;

public class DonutCreationAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"donut_creation", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user forms a mochi donut using their mochi like abilities.", null)});
    protected final ItemSpawnComponent itemSpawnComponent = new ItemSpawnComponent((IAbility)this);
    private final AltModeComponent altModeComponent;
    private static final float COOLDOWN = 30.0f;
    private static final ResourceLocation RAW = new ResourceLocation("cartaddon", "textures/items/raw_mochi_donut.png");
    private static final ResourceLocation BAKED = new ResourceLocation("cartaddon", "textures/items/mochi_donut.png");
    public static final AbilityCore<DonutCreationAbility> INSTANCE = new AbilityCore.Builder("Donut Creation", AbilityCategory.DEVIL_FRUITS, DonutCreationAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)30.0f, (float)180.0f)}).build();

    public DonutCreationAbility(AbilityCore<DonutCreationAbility> core) {
        super(core);
        this.isNew = true;
        this.altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.RAW).addChangeModeEvent(this::onAltModeChange);
        this.addComponents(new AbilityComponent[]{this.itemSpawnComponent, this.altModeComponent});
        this.addUseEvent(200, this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.itemSpawnComponent.spawnItem(entity, this.createItemStack(entity));
        if (this.altModeComponent.getCurrentMode() == Mode.RAW) {
            this.cooldownComponent.startCooldown(entity, 30.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.BAKED) {
            this.cooldownComponent.startCooldown(entity, 180.0f);
        }
    }

    public ItemStack createItemStack(LivingEntity entity) {
        ItemStack itemStack = new ItemStack((IItemProvider)CartItems.RAW_MOCHI_DONUT.get());
        if (this.altModeComponent.getCurrentMode() == Mode.BAKED) {
            itemStack = new ItemStack((IItemProvider)CartItems.MOCHI_DONUT.get());
        }
        return itemStack;
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.RAW) {
            this.setDisplayIcon(RAW);
        } else if (mode == Mode.BAKED) {
            this.setDisplayIcon(BAKED);
        }
    }

    public static enum Mode {
        RAW,
        BAKED;

    }
}

