/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mochi2;

import java.util.List;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CarvedMochiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"carved_mochi", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user winds up an attack in their donut form, and upon release, jumps into the air and lands with a devastating blow", null)});
    public static final AbilityCore<CarvedMochiAbility> INSTANCE = new AbilityCore.Builder("Carved Mochi", AbilityCategory.DEVIL_FRUITS, CarvedMochiAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)65.0f), CooldownComponent.getTooltip((float)400.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    protected final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(200, this::startContinuityEvent).addTickEvent(200, this::tickContinuityEvent).addEndEvent(200, this::endContinuityEvent);
    protected final DamageTakenComponent damageTakenComponent;
    protected final HitTrackerComponent hitTrackerComponent;
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(100, this::startChargingEvent).addTickEvent(this::tickChargingEvent).addEndEvent(100, this::endChargingEvent);
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    protected final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.MOCHI_ABILITY, new AbilityPool2[0]);
    private boolean hasLanded = true;
    private boolean startsInLiquid = false;
    private static final AbilityAttributeModifier SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_MOVEMENT_SPEED_UUID, INSTANCE, "Carved Mochi Speed Modifier", 1.45, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AbilityAttributeModifier JUMP_BOOST_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_JUMP_BOOST_UUID, INSTANCE, "Carved Mochi Jump Modifier", 6.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final float RANGE = 4.5f;
    private static final float DAMAGE = 65.0f;
    private final int COOLDOWN = 400;

    public CarvedMochiAbility(AbilityCore<CarvedMochiAbility> core) {
        super(core);
        this.damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
        this.hitTrackerComponent = new HitTrackerComponent((IAbility)this);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.statsComponent, this.chargeComponent, this.continuousComponent, this.damageTakenComponent, this.hitTrackerComponent, this.dealDamageComponent, this.rangeComponent, this.morphComponent});
        this.statsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)SPEED_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.JUMP_HEIGHT, (AttributeModifier)JUMP_BOOST_MODIFIER);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::onUseEvent);
        this.addUseEvent(AbilityLimits::usingBrawler);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous() && !this.chargeComponent.isCharging()) {
            this.chargeComponent.startCharging(entity, 100.0f);
        }
        if (this.chargeComponent.isCharging() && this.chargeComponent.getChargeTime() > 20.0f) {
            this.chargeComponent.stopCharging(entity);
            this.continuousComponent.startContinuity(entity);
        }
    }

    private void startChargingEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.CARVED_ROLLING_MOCHI.get());
        this.statsComponent.applyModifiers(entity);
    }

    private void tickChargingEvent(LivingEntity entity, IAbility ability) {
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.MOCHI_LOGIA.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
    }

    private void endChargingEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.stopMorph(entity);
        this.statsComponent.removeModifiers(entity);
        this.continuousComponent.triggerContinuity(entity, this.getContinueTime(entity));
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hasLanded = false;
        this.startsInLiquid = entity.func_70090_H();
        this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.CARVED_MOCHI.get());
        Vector3d speed = WyHelper.propulsion((LivingEntity)entity, (double)1.05, (double)1.05);
        AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)1.1, (double)speed.field_72449_c);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!this.startsInLiquid && entity.func_70090_H() && !this.hasLanded) {
            this.hasLanded = true;
        }
        if (this.startsInLiquid && entity.func_70090_H() && entity.func_213322_ci().field_72448_b <= 0.0) {
            this.hasLanded = true;
        }
        if (entity.func_233570_aj_() && this.continuousComponent.getContinueTime() > 10.0f && !this.hasLanded) {
            this.hasLanded = true;
        }
        if (this.hasLanded) {
            this.onLanding(entity);
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.stopMorph(entity);
        this.hitTrackerComponent.clearHits();
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    public void onLanding(LivingEntity entity) {
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)entity.func_226277_ct_(), (double)(entity.func_226278_cu_() + 1.0), (double)entity.func_226281_cx_(), (float)2.5f);
        explosion.setExplosionSound(true);
        explosion.setStaticDamage(0.0f);
        explosion.setDestroyBlocks(true);
        explosion.doExplosion();
        List targets = this.rangeComponent.getTargetsInArea(entity, 4.5f);
        targets.remove(entity);
        AbilityDamageSource source = (AbilityDamageSource)ModDamageSource.causeAbilityDamage((LivingEntity)entity, (AbilityCore)this.getCore()).setBlunt();
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !entity.func_70685_l((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 65.0f, (DamageSource)source)) continue;
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 2));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 30, 0));
            AbilityHelper.disableAbilities((LivingEntity)target, (int)100, abl -> abl.hasComponent(ModAbilityKeys.POOL) && ((PoolComponent)abl.getComponent(ModAbilityKeys.POOL).get()).containsPool(ModAbilityPools.TEKKAI_LIKE));
        }
        if (!entity.field_70170_p.field_72995_K && targets.size() > 0) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
    }

    public float getContinueTime(LivingEntity entity) {
        return -1.0f;
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (damageSource == DamageSource.field_76379_h && this.continuousComponent.isContinuous() || this.chargeComponent.isCharging()) {
            return 0.0f;
        }
        return damage;
    }
}

