/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.marineloyalty;

import net.MrMagicalCart.cartaddon.init.CartEntities;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PacifistaReinforcementsAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"pacifista_reinforcements", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user calls in pacifista reinforcements.", null)});
    private static final float COOLDOWN = 2400.0f;
    public static final AbilityCore<PacifistaReinforcementsAbility> INSTANCE = new AbilityCore.Builder("Pacifista Reinforcements", AbilityCategory.FACTION, PacifistaReinforcementsAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)2400.0f)}).setUnlockCheck(PacifistaReinforcementsAbility::canUnlock).build();

    public PacifistaReinforcementsAbility(AbilityCore<PacifistaReinforcementsAbility> core) {
        super(core);
        this.isNew = true;
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        EntityType px = (EntityType)CartEntities.PACIFISTA_TWO.get();
        int max = 1;
        if (props.hasMarineRank(FactionHelper.MarineRank.FLEET_ADMIRAL)) {
            max = 2;
        }
        int i = 0;
        while ((double)i < WyHelper.randomWithRange((int)1, (int)max)) {
            BlockPos spawnPos = WyHelper.findOnGroundSpawnLocation((World)entity.field_70170_p, (EntityType)px, (BlockPos)entity.func_233580_cy_(), (int)10);
            if (spawnPos != null) {
                px.func_220342_a((ServerWorld)entity.field_70170_p, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
            }
            ++i;
        }
        this.cooldownComponent.startCooldown(entity, 2400.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        return props.hasMarineRank(FactionHelper.MarineRank.ADMIRAL);
    }
}

