/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.maguextra;

import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.entities.projectiles.maguextra.NewRyuseiKazanProjectile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class NewRyuseiKazanAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"ryusei_kazan", (Pair[])new Pair[]{ImmutablePair.of((Object)"Functions like 'Dai Funka', but multiple fists are launched at the opponent", null), ImmutablePair.of((Object)"Creates lava upon hitting a block.", null), ImmutablePair.of((Object)"Creates an explosion upon hitting a block.", null)});
    private static final float COOLDOWN = 400.0f;
    public static final AbilityCore<NewRyuseiKazanAbility> INSTANCE;
    private static final TranslationTextComponent LAVA_NAME;
    private static final TranslationTextComponent EXPLOSIVE_NAME;
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::onContinuityStart);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent((IAbility)this).addTriggerEvent(this::onRepeaterTrigger).addStopEvent(this::onRepeaterStop);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final AltModeComponent altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.LAVA).addChangeModeEvent(this::onAltModeChange);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private boolean grief = true;

    public NewRyuseiKazanAbility(AbilityCore<NewRyuseiKazanAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.animationComponent, this.continuousComponent, this.repeaterComponent, this.projectileComponent, this.altModeComponent});
        super.addCanUseCheck(AbilityLimits::usingBrawler);
        super.addUseEvent(this::onUse);
    }

    private void onUse(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.LAVA) {
            this.grief = true;
        } else if (this.altModeComponent.getCurrentMode() == Mode.EXPLOSION) {
            this.grief = false;
        }
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
        } else {
            this.continuousComponent.triggerContinuity(entity);
        }
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.repeaterComponent.start(entity, 10, 5);
        this.animationComponent.start(entity, ModAnimations.PUNCH_RUSH);
    }

    private void onRepeaterTrigger(LivingEntity entity, IAbility ability) {
        if (AbilityLimits.cancelBrawler(entity)) {
            this.repeaterComponent.stop(entity);
        }
        Vector3d lookVec = entity.func_70040_Z().func_72432_b();
        NewRyuseiKazanProjectile proj = (NewRyuseiKazanProjectile)this.projectileComponent.getNewProjectile(entity);
        if (lookVec.field_72448_b > 0.7) {
            proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 3.0f, 8.0f);
            proj.setMaxLife(300);
            proj.setGravity(0.05f);
        } else {
            proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 2.5f, 4.0f);
        }
        entity.field_70170_p.func_217376_c((Entity)proj);
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.MAGU_SFX.get(), SoundCategory.PLAYERS, 3.0f, 1.0f);
    }

    private void onRepeaterStop(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        this.cooldownComponent.startCooldown(entity, 400.0f);
        this.animationComponent.stop(entity);
    }

    private NewRyuseiKazanProjectile createProjectile(LivingEntity entity) {
        NewRyuseiKazanProjectile proj = new NewRyuseiKazanProjectile(entity.field_70170_p, entity, (IAbility)this);
        if (this.grief) {
            proj.setGrief(true);
        } else {
            proj.setGrief(false);
        }
        return proj;
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (!this.continuousComponent.isContinuous()) {
            if (mode == Mode.LAVA) {
                this.grief = true;
            } else if (mode == Mode.EXPLOSION) {
                this.grief = false;
            }
        }
    }

    static {
        LAVA_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.ryusei_kazan.lava_mode", (String)"Lava Mode"));
        EXPLOSIVE_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.ryusei_kazan.explosive_mode", (String)"Explosive Mode"));
        INSTANCE = new AbilityCore.Builder("Ryusei Kazan", AbilityCategory.DEVIL_FRUITS, NewRyuseiKazanAbility::new).addDescriptionLine(new ITextComponent[]{DESCRIPTION[0]}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> LAVA_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1]}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> EXPLOSIVE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[2]}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)400.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.MAGMA).build();
    }

    public static enum Mode {
        LAVA,
        EXPLOSION;

    }
}

