/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.maguextra;

import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.init.CartResources;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public class NewMagmaCoatingAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"magma_coating", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user coats their arm with magma", null)});
    private static final float THRESHOLD = 600.0f;
    private static final float COOLDOWN = 200.0f;
    public static final AbilityCore<NewMagmaCoatingAbility> INSTANCE = new AbilityCore.Builder("Magma Coating", AbilityCategory.DEVIL_FRUITS, NewMagmaCoatingAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)25.0f), ContinuousComponent.getTooltip((float)600.0f), CooldownComponent.getTooltip((float)200.0f)}).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceType(new SourceType[]{SourceType.FIST}).setSourceElement(SourceElement.MAGMA).build();
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent((IAbility)this, OVERLAY, new AbilityOverlay[0]);
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setOverlayPart(AbilityOverlay.OverlayPart.LIMB).setTexture(CartResources.MAGMA_COATING).build();

    public NewMagmaCoatingAbility(AbilityCore<NewMagmaCoatingAbility> core) {
        super(core);
        this.isNew = true;
        this.continuousComponent.addStartEvent(this::onContinuityStart).addEndEvent(this::onContinuityEnd);
        super.addComponents(new AbilityComponent[]{this.skinOverlayComponent});
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.showAll(entity);
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.hideAll(entity);
    }

    public float getPunchDamage() {
        return 25.0f;
    }

    public float getPunchCooldown() {
        return 200.0f;
    }

    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        AbilityHelper.setSecondsOnFireBy((Entity)target, (int)5, (LivingEntity)entity);
        return true;
    }

    public float getPunchHoldTime() {
        return 600.0f;
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    public int getUseLimit() {
        return -1;
    }
}

