/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.maguextra;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.api.protection.block.LavaImmuneProtectionRule;

public class NewLavaFlowAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"lava_flow", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user covers their legs into lava creating a path while walking trough it", null)});
    private static final int COOLDOWN = 300;
    private static final int HOLD_TIME = 100;
    public static final AbilityCore<NewLavaFlowAbility> INSTANCE = new AbilityCore.Builder("Lava Flow", AbilityCategory.DEVIL_FRUITS, NewLavaFlowAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)300.0f), ContinuousComponent.getTooltip((float)100.0f)}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(new BlockProtectionRule[]{DefaultProtectionRules.CORE_FOLIAGE_ORE, LavaImmuneProtectionRule.INSTANCE}).addApprovedMaterials(new Material[]{Material.field_151587_i}).addBannedBlocks(new Block[]{Blocks.field_150343_Z}).build();
    private int originY = -1;

    public NewLavaFlowAbility(AbilityCore<NewLavaFlowAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.continuousComponent});
        super.addUseEvent(this::onUse);
    }

    private void onUse(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 100.0f);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.originY = entity.func_233580_cy_().func_177956_o() - 5;
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (this.originY >= 0) {
            boolean canPlaceBlocks;
            BlockPos pos = entity.func_233580_cy_().func_177977_b();
            BlockState state = entity.field_70170_p.func_180495_p(pos);
            boolean isBlockBelowOrigin = pos.func_177956_o() < this.originY;
            boolean areEyesInLava = entity.func_208600_a((ITag)FluidTags.field_206960_b);
            boolean bl = canPlaceBlocks = GRIEF_RULE.check(entity.field_70170_p, pos, state) && !areEyesInLava;
            if (canPlaceBlocks) {
                AbilityHelper.createFilledSphere((World)entity.field_70170_p, (int)((int)entity.func_226277_ct_()), (int)((int)entity.func_226278_cu_() - 2), (int)((int)entity.func_226281_cx_()), (int)4, (Block)Blocks.field_150353_l, (BlockProtectionRule)GRIEF_RULE);
            } else if (areEyesInLava && !isBlockBelowOrigin) {
                AbilityHelper.createFilledSphere((World)entity.field_70170_p, (int)((int)entity.func_226277_ct_()), (int)((int)entity.func_226278_cu_() + 1), (int)((int)entity.func_226281_cx_()), (int)3, (Block)Blocks.field_150353_l, (BlockProtectionRule)GRIEF_RULE);
            }
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }
}

