/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.maguextra;

import net.MrMagicalCart.cartaddon.entities.projectiles.maguextra.NewDaiFunkaProjectile;
import net.MrMagicalCart.cartaddon.init.CartResources;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class NewDaiFunkaAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"dai_funka", (Pair[])new Pair[]{ImmutablePair.of((Object)"Transforms the user's fist into pure magma before expanding and throwing it forward", null), ImmutablePair.of((Object)"Creates lava upon hitting a block.", null), ImmutablePair.of((Object)"Creates an explosion upon hitting a block.", null)});
    private static final TranslationTextComponent LAVA_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.dai_funka.lava_mode", (String)"Lava Mode"));
    private static final TranslationTextComponent EXPLOSIVE_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.mineminenomi.dai_funka.explosive_mode", (String)"Explosive Mode"));
    private static final float CHARGE_TIME = 20.0f;
    private static final float COOLDOWN = 500.0f;
    public static final AbilityCore<NewDaiFunkaAbility> INSTANCE = new AbilityCore.Builder("Dai Funka", AbilityCategory.DEVIL_FRUITS, NewDaiFunkaAbility::new).addDescriptionLine(new ITextComponent[]{DESCRIPTION[0]}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> LAVA_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1]}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> EXPLOSIVE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[2]}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)500.0f), ChargeComponent.getTooltip((float)20.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.MAGMA).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::onChargeStart).addEndEvent(this::onChargeEnd);
    private final SkinOverlayComponent skinOverlayComponent;
    private final ProjectileComponent projectileComponent;
    private final AltModeComponent altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.LAVA).addChangeModeEvent(this::onAltModeChange);
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setOverlayPart(AbilityOverlay.OverlayPart.LIMB).setTexture(CartResources.MAGMA_COATING).build();
    private boolean grief = true;

    public NewDaiFunkaAbility(AbilityCore<NewDaiFunkaAbility> core) {
        super(core);
        this.skinOverlayComponent = new SkinOverlayComponent((IAbility)this, OVERLAY, new AbilityOverlay[0]);
        this.projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.chargeComponent, this.skinOverlayComponent, this.projectileComponent, this.altModeComponent});
        super.addUseEvent(this::onUse);
    }

    private void onUse(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.LAVA) {
            this.grief = true;
        } else if (this.altModeComponent.getCurrentMode() == Mode.EXPLOSION) {
            this.grief = false;
        }
        this.chargeComponent.startCharging(entity, 20.0f);
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.showAll(entity);
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 3.0f, 1.0f);
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.MAGU_SFX.get(), SoundCategory.PLAYERS, 3.0f, 1.0f);
        this.skinOverlayComponent.hideAll(entity);
        this.cooldownComponent.startCooldown(entity, 500.0f);
    }

    private NewDaiFunkaProjectile createProjectile(LivingEntity entity) {
        NewDaiFunkaProjectile proj = new NewDaiFunkaProjectile(entity.field_70170_p, entity, (IAbility)this);
        if (this.grief) {
            proj.setGrief(true);
        } else {
            proj.setGrief(false);
        }
        return proj;
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (this.chargeComponent.isCharging()) {
            if (mode == Mode.LAVA) {
                this.grief = true;
            } else if (mode == Mode.EXPLOSION) {
                this.grief = false;
            }
        }
    }

    public static enum Mode {
        LAVA,
        EXPLOSION;

    }
}

