/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.maguextra;

import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.api.protection.block.LavaImmuneProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NewBakuretsuKazanAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"bakuretsu_kazan", (Pair[])new Pair[]{ImmutablePair.of((Object)"By spreading magma to the surroundings, the user turns everything into lava", null)});
    private static final float MAX_CHARGE_TIME = 100.0f;
    private static final float MIN_COOLDOWN = 100.0f;
    private static final float MAX_COOLDOWN = 600.0f;
    public static final AbilityCore<NewBakuretsuKazanAbility> INSTANCE = new AbilityCore.Builder("Bakuretsu Kazan", AbilityCategory.DEVIL_FRUITS, NewBakuretsuKazanAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)100.0f, (float)600.0f)}).setSourceElement(SourceElement.MAGMA).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, comp -> (double)comp.getChargePercentage() >= 0.3).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(new BlockProtectionRule[]{DefaultProtectionRules.CORE_FOLIAGE_ORE, LavaImmuneProtectionRule.INSTANCE}).build();

    public NewBakuretsuKazanAbility(AbilityCore<NewBakuretsuKazanAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.chargeComponent});
        super.addUseEvent(this::onUse);
    }

    private void onUse(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 100.0f);
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.getChargeTime() % 20.0f == 0.0f) {
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), SoundEvents.field_187662_cZ, SoundCategory.PLAYERS, 10.0f, 1.0f);
        }
        if (this.chargeComponent.getChargeTime() % 10.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.BAKURETSU_KAZAN.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            int range = (int)(this.chargeComponent.getChargePercentage() * 16.0f);
            AbilityHelper.createFilledSphere((World)entity.field_70170_p, (int)((int)entity.func_226277_ct_()), (int)((int)entity.func_226278_cu_()), (int)((int)entity.func_226281_cx_()), (int)range, (Block)Blocks.field_150353_l, (BlockProtectionRule)GRIEF_RULE);
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.BAKURETSU_KAZAN.get(), SoundCategory.PLAYERS, 10.0f, 1.0f);
            float cooldown = 100.0f + this.chargeComponent.getChargeTime() * 5.0f;
            this.cooldownComponent.startCooldown(entity, cooldown);
        }
    }
}

