/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.lunarian;

import net.MrMagicalCart.cartaddon.abilities.lunarian.FlameOnAbility;
import net.MrMagicalCart.cartaddon.abilities.lunarian.LunarianHelper;
import net.MrMagicalCart.cartaddon.entities.projectiles.lunarian.OmoriKayrudonProjectile;
import net.MrMagicalCart.cartaddon.entities.projectiles.lunarian.OmoriVisualProjectile;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class OmoriKayrudonAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"omori_karyudon", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user launches themselves into the air, shooting fire in the form of dragons at their opponents.", null)});
    private static final float COOLDOWN = 500.0f;
    private static final float CHARGE_TIME = 60.0f;
    public static final AbilityCore<OmoriKayrudonAbility> INSTANCE = new AbilityCore.Builder("Omori Karyudon", AbilityCategory.RACIAL, OmoriKayrudonAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChargeComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)500.0f)}).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.FIRE).setUnlockCheck(OmoriKayrudonAbility::canUnlock).build();
    protected final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent((IAbility)this).addTriggerEvent(this::triggerRepeaterEvent).addStopEvent(this::stopRepeaterEvent);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.INIT_JUMP, new AbilityPool2[0]);
    boolean hasFallDamage = true;
    private OmoriVisualProjectile innerRing;
    private OmoriVisualProjectile outerRing;
    Vector3d position = null;

    public OmoriKayrudonAbility(AbilityCore<OmoriKayrudonAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.damageTakenComponent, this.repeaterComponent, this.continuousComponent, this.chargeComponent, this.projectileComponent});
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addCanUseCheck(LunarianHelper.requireFlameOn(3));
        this.addUseEvent(200, this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.isContinuous()) {
            this.continuousComponent.stopContinuity(entity);
        } else {
            this.chargeComponent.startCharging(entity, 60.0f);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        FlameOnAbility flameOnAbility = (FlameOnAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(FlameOnAbility.INSTANCE);
        if (flameOnAbility != null) {
            flameOnAbility.reduceUsage(entity, 3);
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 10, 0, false, false));
        Vector3d startVec = entity.func_213303_ch();
        boolean onGround = entity.field_70170_p.func_217299_a(new RayTraceContext(startVec, startVec.func_72441_c(0.0, -15.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK);
        if (onGround) {
            AbilityHelper.setDeltaMovement((Entity)entity, (double)entity.func_213322_ci().field_72450_a, (double)1.75, (double)entity.func_213322_ci().field_72449_c);
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            entity.func_195064_c(new EffectInstance(Effects.field_76429_m, 2, 0, false, false, false));
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.OMORI_CHARGING.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 0, false, false));
            AbilityHelper.slowEntityFall((LivingEntity)entity);
            RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)64.0);
            if (mop.func_216346_c() != RayTraceResult.Type.MISS) {
                double i = mop.func_216347_e().field_72450_a;
                double j = mop.func_216347_e().field_72448_b;
                double k = mop.func_216347_e().field_72449_c;
                this.position = new Vector3d(i, j, k);
            }
            if (this.chargeComponent.getChargeTime() >= 20.0f) {
                if (this.innerRing == null) {
                    OmoriVisualProjectile omori;
                    this.innerRing = omori = new OmoriVisualProjectile(entity.field_70170_p, entity, this, 10.0f);
                    this.innerRing.func_212361_a((Entity)entity);
                    entity.field_70170_p.func_217376_c((Entity)this.innerRing);
                } else {
                    this.innerRing.func_200602_a(EntityAnchorArgument.Type.FEET, this.position);
                    this.innerRing.field_70125_A = -this.innerRing.field_70125_A;
                    this.innerRing.field_70177_z = -this.innerRing.field_70177_z;
                    this.innerRing.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() - 0.75, entity.func_226281_cx_());
                }
                if (this.outerRing == null) {
                    OmoriVisualProjectile omori;
                    this.outerRing = omori = new OmoriVisualProjectile(entity.field_70170_p, entity, this, 30.0f);
                    this.outerRing.func_212361_a((Entity)entity);
                    entity.field_70170_p.func_217376_c((Entity)this.outerRing);
                } else {
                    this.outerRing.func_200602_a(EntityAnchorArgument.Type.FEET, this.position);
                    this.outerRing.field_70125_A = -this.outerRing.field_70125_A;
                    this.outerRing.field_70177_z = -this.outerRing.field_70177_z;
                    this.outerRing.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() - 2.0, entity.func_226281_cx_());
                }
                RayTraceResult mop2 = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)-0.5);
                double i = mop2.func_216347_e().field_72450_a;
                double j = mop2.func_216347_e().field_72448_b;
                double k = mop2.func_216347_e().field_72449_c;
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.OMORI_FLASH.get()), (Entity)entity, (double)i, (double)j, (double)k);
            }
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.continuousComponent.startContinuity(entity);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hasFallDamage = false;
        this.repeaterComponent.start(entity, 5, 17);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        double k;
        double j;
        double i;
        if (!entity.field_70170_p.field_72995_K) {
            entity.func_195064_c(new EffectInstance(Effects.field_76429_m, 2, 0, false, false, false));
            AbilityHelper.slowEntityFall((LivingEntity)entity);
            RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)64.0);
            if (mop.func_216346_c() != RayTraceResult.Type.MISS) {
                i = mop.func_216347_e().field_72450_a;
                j = mop.func_216347_e().field_72448_b;
                k = mop.func_216347_e().field_72449_c;
                this.position = new Vector3d(i, j, k);
            }
            this.innerRing.func_200602_a(EntityAnchorArgument.Type.FEET, this.position);
            this.innerRing.field_70125_A = -this.innerRing.field_70125_A;
            this.innerRing.field_70177_z = -this.innerRing.field_70177_z;
            this.innerRing.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() - 0.75, entity.func_226281_cx_());
            this.outerRing.func_200602_a(EntityAnchorArgument.Type.FEET, this.position);
            this.outerRing.field_70125_A = -this.outerRing.field_70125_A;
            this.outerRing.field_70177_z = -this.outerRing.field_70177_z;
            this.outerRing.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() - 2.0, entity.func_226281_cx_());
        }
        RayTraceResult mop2 = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)-0.5);
        i = mop2.func_216347_e().field_72450_a;
        j = mop2.func_216347_e().field_72448_b;
        k = mop2.func_216347_e().field_72449_c;
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.OMORI_FLASH.get()), (Entity)entity, (double)i, (double)j, (double)k);
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (this.innerRing != null) {
            this.innerRing.func_70106_y();
            this.innerRing = null;
        }
        if (this.outerRing != null) {
            this.outerRing.func_70106_y();
            this.outerRing = null;
        }
        this.repeaterComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 500.0f);
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 4.5f, 2.0f);
        entity.func_226292_a_(Hand.MAIN_HAND, true);
    }

    private void stopRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        return damage;
    }

    private OmoriKayrudonProjectile createProjectile(LivingEntity entity) {
        OmoriKayrudonProjectile proj = new OmoriKayrudonProjectile(entity.field_70170_p, entity, this);
        return proj;
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.LUNARIAN);
        return race && props.getDoriki() >= 9000.0;
    }
}

