/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.lunarian;

import java.util.UUID;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveStatBonusAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModResources;

public class LunarianPassiveBonuses
extends PassiveStatBonusAbility {
    private static final AttributeModifier LUNARIAN_DAMAGE = new AttributeModifier(UUID.fromString("743dbdf0-47ef-4dae-8832-266f9199fc6d"), "Lunarian Attack Damage Bonus", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier LUNARIAN_JUMP = new AttributeModifier(UUID.fromString("69983200-4e02-43f6-8e01-7aa619c82840"), "Lunarian Jump Boost Addition", 1.25, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier LUNARIAN_SPEED = new AttributeModifier(UUID.fromString("a09632cb-1192-460d-9dfe-5c6cd07c3ce0"), "Lunarian Speed Bonus", 0.02, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier JUMP_RESISTANCE_MODIFIER = new AttributeModifier(UUID.fromString("749239b5-9c97-4dc7-87ad-7b8220d07e58"), "Lunarian Jump Resistance", 2.25, AttributeModifier.Operation.ADDITION);
    private static final Predicate<LivingEntity> LUNARIAN_CHECK = entity -> {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.LUNARIAN);
        return race && props.getDoriki() >= 0.0;
    };
    public static final AbilityCore<LunarianPassiveBonuses> INSTANCE = new AbilityCore.Builder("Lunarian Passive Bonuses", AbilityCategory.RACIAL, AbilityType.PASSIVE, LunarianPassiveBonuses::new).setIcon(ModResources.PERK_ICON).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{ChangeStatsComponent.getTooltip()}).setUnlockCheck(LunarianPassiveBonuses::canUnlock).build();

    public LunarianPassiveBonuses(AbilityCore<LunarianPassiveBonuses> core) {
        super(core);
        this.pushStaticAttribute(Attributes.field_233823_f_, LUNARIAN_DAMAGE);
        this.pushStaticAttribute((Attribute)ModAttributes.JUMP_HEIGHT.get(), LUNARIAN_JUMP);
        this.pushStaticAttribute(Attributes.field_233821_d_, LUNARIAN_SPEED);
        this.pushStaticAttribute((Attribute)ModAttributes.FALL_RESISTANCE.get(), JUMP_RESISTANCE_MODIFIER);
    }

    public Predicate<LivingEntity> getCheck() {
        return LUNARIAN_CHECK;
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.LUNARIAN);
        return race && props.getDoriki() >= 0.0;
    }
}

