/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.lunarian;

import net.MrMagicalCart.cartaddon.abilities.lunarian.FlameOffAbility;
import net.MrMagicalCart.cartaddon.abilities.lunarian.FlameOnAbility;
import net.MrMagicalCart.cartaddon.init.CartI18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class LunarianHelper {
    public static boolean hasSpeedActive(LivingEntity entity) {
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        FlameOffAbility flameOffAbility = (FlameOffAbility)abilityProps.getEquippedAbility(FlameOffAbility.INSTANCE);
        boolean active = flameOffAbility != null && flameOffAbility.isContinuous();
        return active;
    }

    public static boolean hasFlamesOn(LivingEntity entity) {
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        FlameOnAbility flameOnAbility = (FlameOnAbility)abilityProps.getEquippedAbility(FlameOnAbility.INSTANCE);
        boolean active = flameOnAbility != null && flameOnAbility.isContinuous();
        return active;
    }

    public static Ability.ICanUseEvent<LivingEntity, IAbility> requireFlameOn(int neededStacks) {
        return (entity, ability) -> {
            FlameOnAbility flameOnAbility = (FlameOnAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(FlameOnAbility.INSTANCE);
            if (flameOnAbility != null && flameOnAbility.isContinuous()) {
                int stacks = flameOnAbility.getComponent(ModAbilityKeys.STACK).map(comp -> comp.getStacks()).orElse(0);
                if (stacks - neededStacks < 0) {
                    TranslationTextComponent message = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_ABILITY_STACKS, new Object[]{neededStacks, FlameOnAbility.INSTANCE.getLocalizedName().getString()});
                    return AbilityUseResult.fail((ITextComponent)message);
                }
                return AbilityUseResult.success();
            }
            return AbilityUseResult.fail((ITextComponent)CartI18n.ABILITY_MESSAGE_NEED_FLAME_ON);
        };
    }
}

