/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.lunarian;

import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.lunarian.FlameOnAbility;
import net.MrMagicalCart.cartaddon.abilities.lunarian.LunarianHelper;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.MrMagicalCart.cartaddon.particles.effects.lunarian.BigFlamingTwisterParticleEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class FlamingTwisterAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"flaming_twister", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user generates a small pillar of flame around themselves, inflicting fire, slight dizzy, and slowness.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final int ON_HOLD = 50;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 200;
    private static final double SIZE = 2.5;
    private static final float DAMAGE = 3.0f;
    public static final AbilityCore<FlamingTwisterAbility> INSTANCE = new AbilityCore.Builder("Flaming Twister", AbilityCategory.RACIAL, FlamingTwisterAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)7.0f), ContinuousComponent.getTooltip((float)100.0f), CooldownComponent.getTooltip((float)100.0f, (float)200.0f), RangeComponent.getTooltip((float)3.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.FIRE).setUnlockCheck(FlamingTwisterAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final Interval particleInterval = new Interval(2);
    private final Interval clearHitsInterval = new Interval(20);

    public FlamingTwisterAbility(AbilityCore<FlamingTwisterAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.continuousComponent, this.hitTrackerComponent, this.dealDamageComponent});
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addCanUseCheck(LunarianHelper.requireFlameOn(2));
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 100.0f);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        FlameOnAbility flameOnAbility = (FlameOnAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(FlameOnAbility.INSTANCE);
        if (flameOnAbility != null) {
            flameOnAbility.reduceUsage(entity, 2);
        }
        this.hitTrackerComponent.clearHits();
        this.particleInterval.restartIntervalToZero();
        ((ModDamageSource)this.dealDamageComponent.getDamageSource(entity)).setUnavoidable();
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (super.canUse(entity).isFail()) {
            this.continuousComponent.stopContinuity(entity);
        }
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.BIG_FLAMING_TWISTER.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (ParticleEffect.Details)BigFlamingTwisterParticleEffect.NO_DETAILS);
        float horizontal = 3.0f;
        float vertical = 7.0f;
        float dmg = 7.0f;
        List targets = WyHelper.getNearbyLiving((Vector3d)entity.func_213303_ch(), (IWorld)entity.field_70170_p, (double)horizontal, (double)vertical, (double)horizontal, (Predicate)ModEntityPredicates.getEnemyFactions((LivingEntity)entity));
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, dmg)) continue;
            target.func_70015_d(3);
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 1, false, false));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 5, 0, false, false));
        }
        if (this.clearHitsInterval.canTick()) {
            this.hitTrackerComponent.clearHits();
        }
        AbilityHelper.slowEntityFall((LivingEntity)entity);
        if (!LunarianHelper.hasFlamesOn(entity)) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1, false, false));
        }
        if (!AbilityLimits.isDry(entity, (IAbility)this)) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        float cooldown = 100.0f + this.continuousComponent.getContinueTime();
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.LUNARIAN);
        return race && props.getDoriki() >= 5500.0;
    }
}

