/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.lunarian;

import net.MrMagicalCart.cartaddon.abilities.lunarian.FlameOnAbility;
import net.MrMagicalCart.cartaddon.abilities.lunarian.LunarianHelper;
import net.MrMagicalCart.cartaddon.entities.projectiles.lunarian.FlamingSlashProjectile;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class FlamingSlashAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"flaming_slash", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user creates a air slash of fire from their weapon, inflicting fire damage. (Increases distance and damage with \u00a7aFlame On\u00a7r)", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final float COOLDOWN = 200.0f;
    private static final float DAMAGE = 40.0f;
    public static final AbilityCore<FlamingSlashAbility> INSTANCE = new AbilityCore.Builder("Flaming Slash", AbilityCategory.RACIAL, FlamingSlashAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)200.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.SLASH}).setSourceElement(SourceElement.FIRE).setUnlockCheck(FlamingSlashAbility::canUnlock).build();
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);

    public FlamingSlashAbility(AbilityCore<FlamingSlashAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.animationComponent, this.projectileComponent});
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addCanUseCheck(LunarianHelper.requireFlameOn(1));
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        FlameOnAbility flameOnAbility = (FlameOnAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(FlameOnAbility.INSTANCE);
        if (flameOnAbility != null) {
            flameOnAbility.reduceUsage(entity, 1);
        }
        this.animationComponent.start(entity, ModAnimations.CANNON_SLASH, 7);
        this.projectileComponent.shoot(entity);
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private FlamingSlashProjectile createProjectile(LivingEntity entity) {
        FlamingSlashProjectile proj = new FlamingSlashProjectile(entity.field_70170_p, entity, this);
        return proj;
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.LUNARIAN);
        return race && props.getDoriki() >= 4500.0;
    }
}

