/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.lunarian;

import net.MrMagicalCart.cartaddon.abilities.lunarian.LunarianHelper;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.ConcasseAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class FlameRushAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"flame_rush", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user propels themselves forward with fire. (Decreased distance with \u00a7aFlame On\u00a7r)", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final float LONG_COOLDOWN = 200.0f;
    private static final float SHORT_COOLDOWN = 30.0f;
    public static final AbilityCore<FlameRushAbility> INSTANCE = new AbilityCore.Builder("Flame Rush", AbilityCategory.RACIAL, FlameRushAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, StackComponent.getTooltip((int)3), AbilityHelper.createShortLongCooldownStat((float)10.0f, (float)210.0f)}).setUnlockCheck(FlameRushAbility::canUnlock).build();
    private final StackComponent stackComponent = new StackComponent((IAbility)this, 3).addStackChangeEvent(this::onStacksChange);
    private final DamageTakenComponent damageTakenComponent;
    private boolean hasFallDamage = true;

    public FlameRushAbility(AbilityCore<FlameRushAbility> core) {
        super(core);
        this.isNew = true;
        this.damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
        this.addComponents(new AbilityComponent[]{this.stackComponent, this.damageTakenComponent});
        this.setOGCD();
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::onUseEvent);
        this.addTickEvent(this::tickEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        boolean conActive;
        Vector3d look = entity.func_70040_Z().func_216372_d(2.75, entity.func_70040_Z().field_72448_b >= 0.0 ? 2.0 : 2.15, 2.75);
        if (LunarianHelper.hasFlamesOn(entity)) {
            look = entity.func_70040_Z().func_216372_d(1.8, entity.func_70040_Z().field_72448_b >= 0.0 ? 1.75 : 2.0, 1.8);
        }
        this.hasFallDamage = false;
        AbilityHelper.setDeltaMovement((Entity)entity, (Vector3d)look);
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.MERA_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.HEAT_DASH.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        ConcasseAbility concasseAbility = (ConcasseAbility)abilityProps.getEquippedAbility(ConcasseAbility.INSTANCE);
        boolean bl = conActive = concasseAbility != null && concasseAbility.isContinuous();
        if (!conActive && LunarianHelper.hasFlamesOn(entity)) {
            entity.func_195064_c(new EffectInstance(Effects.field_204839_B, 30, 0, false, false));
        } else if (entity.func_70644_a(Effects.field_204839_B)) {
            entity.func_195063_d(Effects.field_204839_B);
        }
        this.stackComponent.addStacks(entity, (IAbility)this, -1);
    }

    private void onStacksChange(LivingEntity entity, IAbility ability, int stacks) {
        if (stacks <= 0) {
            this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
            this.stackComponent.revertStacksToDefault(entity, (IAbility)this);
        }
        this.cooldownComponent.startCooldown(entity, 10.0f);
    }

    public void tickEvent(LivingEntity entity, IAbility ability) {
        if (this.getLastUseGametime() <= 0L && this.stackComponent.getDefaultStacks() <= 0) {
            this.stackComponent.setDefaultStacks(this.getMaxDashes(entity));
            this.stackComponent.revertStacksToDefault(entity, (IAbility)this);
        }
        if (!entity.field_70170_p.field_72995_K && !this.hasFallDamage && this.stackComponent.getStacks() < this.stackComponent.getDefaultStacks() && entity.func_233570_aj_() && entity.field_70170_p.func_82737_E() > this.getLastUseGametime() + 10L) {
            this.resetStacks(entity);
        }
    }

    private void resetStacks(LivingEntity entity) {
        if (this.stackComponent.getStacks() != this.stackComponent.getDefaultStacks()) {
            this.cooldownComponent.stopCooldown(entity);
            this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
        }
        this.stackComponent.setStacks(entity, (IAbility)this, this.getMaxDashes(entity));
        this.stackComponent.setDefaultStacks(this.getMaxDashes(entity));
        this.hasFallDamage = true;
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.resetStacks(entity);
            return 0.0f;
        }
        return damage;
    }

    private int getMaxDashes(LivingEntity entity) {
        return 3;
    }

    private float getCooldownTicks() {
        return (float)(this.stackComponent.getDefaultStacks() - this.stackComponent.getStacks()) * 70.0f;
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.LUNARIAN);
        return race && props.getDoriki() >= 3000.0;
    }
}

