/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.lunarian;

import java.util.UUID;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class FlameOnAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"flame_on", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user turns their flames on, increasing damage and defense.", null)});
    private static final int HOLD_TIME = 300;
    private static final int COOLDOWN = 240;
    public static final AbilityCore<FlameOnAbility> INSTANCE = new AbilityCore.Builder("Flame On", AbilityCategory.RACIAL, FlameOnAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip((float)400.0f), CooldownComponent.getTooltip((float)240.0f), StackComponent.getTooltip((int)12), ChangeStatsComponent.getTooltip()}).setUnlockCheck(FlameOnAbility::canUnlock).build();
    private static final AbilityAttributeModifier ARMOR_MODIFIER = new AbilityAttributeModifier(UUID.fromString("0d93bd7f-ef9e-4a28-93dd-dff2e4b34459"), INSTANCE, "Flame On Armor Modifier", 30.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ARMOR_TOUGHNESS_MODIFIER = new AbilityAttributeModifier(UUID.fromString("be569657-d112-48cf-a973-262523621c9c"), INSTANCE, "Flame On Armor Toughness Modifier", 6.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER = new AbilityAttributeModifier(UUID.fromString("e7a13c8c-991f-4752-a795-efb12899fe60"), INSTANCE, "Flame On Toughness Modifier", 6.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ATTACK_DAMAGE_MODIFIER = new AbilityAttributeModifier(UUID.fromString("ae379ae3-f1fa-4207-854a-2505e4fdb08e"), INSTANCE, "Flame On Attack Damage Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("0fbf0167-fe75-42d6-9804-35065865b84a"), INSTANCE, "Flame On Movement Speed Modifier", -0.0175, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addOnHitEvent(this::hitEvent);
    private final ChangeStatsComponent changeStatsComponent;
    private final StackComponent stackComponent = new StackComponent((IAbility)this, 12);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::damageTakenEvent, DamageTakenComponent.DamageState.HURT);

    public FlameOnAbility(AbilityCore<FlameOnAbility> core) {
        super(core);
        this.changeStatsComponent = new ChangeStatsComponent((IAbility)this);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.hitTriggerComponent, this.continuousComponent, this.changeStatsComponent, this.stackComponent, this.damageTakenComponent});
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)ARMOR_TOUGHNESS_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233823_f_, (AttributeModifier)ATTACK_DAMAGE_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)SPEED_MODIFIER);
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 400.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.applyModifiers(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance(Effects.field_76426_n, 2, 0, false, false, false));
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)-0.75);
        double i = mop.func_216347_e().field_72450_a;
        double j = mop.func_216347_e().field_72448_b;
        double k = mop.func_216347_e().field_72449_c;
        Vector3d behindEntity = new Vector3d(i, j, k);
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.FLAME_ON.get()), (Entity)entity, (double)behindEntity.field_72450_a, (double)behindEntity.field_72448_b, (double)behindEntity.field_72449_c);
        if (!AbilityLimits.isDry(entity, (IAbility)this)) {
            this.continuousComponent.stopContinuity(entity);
        }
        if (!entity.field_70170_p.field_72995_K && this.stackComponent.getStacks() <= 0) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.removeModifiers(entity);
        float cooldown = 240.0f;
        this.cooldownComponent.startCooldown(entity, cooldown);
        this.stackComponent.revertStacksToDefault(entity, (IAbility)this);
    }

    private boolean hitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            target.func_70015_d(5);
        }
        return true;
    }

    private float damageTakenEvent(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (this.continuousComponent.isContinuous() && damage >= 3.0f) {
            if (this.stackComponent.getStacks() >= 0) {
                this.stackComponent.addStacks(entity, ability, -1);
            } else {
                this.continuousComponent.stopContinuity(entity);
            }
        }
        return damage;
    }

    public void reduceUsage(LivingEntity entity, int number) {
        if (!entity.field_70170_p.field_72995_K) {
            int newStacks = this.stackComponent.getStacks() - number;
            this.stackComponent.setStacks(entity, (IAbility)this, newStacks);
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.LUNARIAN);
        return race && props.getDoriki() >= 1000.0;
    }
}

