/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.lunarian;

import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.lunarian.FlameOnAbility;
import net.MrMagicalCart.cartaddon.abilities.lunarian.LunarianHelper;
import net.MrMagicalCart.cartaddon.entities.projectiles.lunarian.AndonProjectile;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public class AndonAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"andon", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user generates flames into their hand, and launches it.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final int COOLDOWN = 300;
    public static final AbilityCore<AndonAbility> INSTANCE = new AbilityCore.Builder("Andon", AbilityCategory.RACIAL, AndonAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)300.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.FIRE).setUnlockCheck(AndonAbility::canUnlock).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);

    public AndonAbility(AbilityCore<? extends PunchAbility2> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.projectileComponent});
        this.continuousComponent.addTickEvent(100, this::tickContinuityEvent);
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addCanUseCheck(LunarianHelper.requireFlameOn(1));
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && entity.field_82175_bq) {
            this.projectileComponent.shoot(entity, 2.0f, 0.0f);
            FlameOnAbility flameOnAbility = (FlameOnAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(FlameOnAbility.INSTANCE);
            if (flameOnAbility != null) {
                flameOnAbility.reduceUsage(entity, 1);
            }
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private AndonProjectile createProjectile(LivingEntity entity) {
        AndonProjectile proj = new AndonProjectile(entity.field_70170_p, entity, (Ability)this);
        return proj;
    }

    public float getPunchCooldown() {
        return 300.0f;
    }

    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        this.projectileComponent.shoot(entity, 2.0f, 0.0f);
        return true;
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    public boolean isParallel() {
        return true;
    }

    public int getUseLimit() {
        return 1;
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.LUNARIAN);
        return race && props.getDoriki() >= 2000.0;
    }
}

